package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EntityRecognitionConfig(
    entityTypes: Iterable[zio.aws.comprehend.model.EntityTypesListItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig = {
    import EntityRecognitionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig
      .builder()
      .entityTypes(entityTypes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly =
    zio.aws.comprehend.model.EntityRecognitionConfig.wrap(buildAwsValue())
}
object EntityRecognitionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognitionConfig =
      zio.aws.comprehend.model.EntityRecognitionConfig(entityTypes.map { item =>
        item.asEditable
      })
    def entityTypes: List[zio.aws.comprehend.model.EntityTypesListItem.ReadOnly]
    def getEntityTypes: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.EntityTypesListItem.ReadOnly
    ]] = ZIO.succeed(entityTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig
  ) extends zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly {
    override val entityTypes
        : List[zio.aws.comprehend.model.EntityTypesListItem.ReadOnly] = impl
      .entityTypes()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.EntityTypesListItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig
  ): zio.aws.comprehend.model.EntityRecognitionConfig.ReadOnly = new Wrapper(
    impl
  )
}
