package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeSentimentDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest = {
    import DescribeSentimentDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest
      .wrap(buildAwsValue())
}
object DescribeSentimentDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest =
      zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest
  ) extends zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest
  ): zio.aws.comprehend.model.DescribeSentimentDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
