package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{ComprehendArn, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartDominantLanguageDetectionJobResponse(
    jobId: Optional[JobId] = Optional.Absent,
    jobArn: Optional[ComprehendArn] = Optional.Absent,
    jobStatus: Optional[zio.aws.comprehend.model.JobStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse = {
    import StartDominantLanguageDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse
      .wrap(buildAwsValue())
}
object StartDominantLanguageDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse =
      zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobStatus.map(value => value)
      )
    def jobId: Optional[JobId]
    def jobArn: Optional[ComprehendArn]
    def jobStatus: Optional[zio.aws.comprehend.model.JobStatus]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ) extends zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly {
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Optional[ComprehendArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobStatus: Optional[zio.aws.comprehend.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobResponse
  ): zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
