package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDataSecurityConfig(
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig = {
    import UpdateDataSecurityConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig
      .builder()
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly =
    zio.aws.comprehend.model.UpdateDataSecurityConfig.wrap(buildAwsValue())
}
object UpdateDataSecurityConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateDataSecurityConfig =
      zio.aws.comprehend.model.UpdateDataSecurityConfig(
        modelKmsKeyId.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def modelKmsKeyId: Optional[KmsKeyId]
    def volumeKmsKeyId: Optional[KmsKeyId]
    def vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig
  ) extends zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly {
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateDataSecurityConfig
  ): zio.aws.comprehend.model.UpdateDataSecurityConfig.ReadOnly = new Wrapper(
    impl
  )
}
