package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentReaderConfig(
    documentReadAction: zio.aws.comprehend.model.DocumentReadAction,
    documentReadMode: Optional[zio.aws.comprehend.model.DocumentReadMode] =
      Optional.Absent,
    featureTypes: Optional[
      Iterable[zio.aws.comprehend.model.DocumentReadFeatureTypes]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig = {
    import DocumentReaderConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig
      .builder()
      .documentReadAction(documentReadAction.unwrap)
      .optionallyWith(documentReadMode.map(value => value.unwrap))(
        _.documentReadMode
      )
      .optionallyWith(
        featureTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.featureTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly =
    zio.aws.comprehend.model.DocumentReaderConfig.wrap(buildAwsValue())
}
object DocumentReaderConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentReaderConfig =
      zio.aws.comprehend.model.DocumentReaderConfig(
        documentReadAction,
        documentReadMode.map(value => value),
        featureTypes.map(value => value)
      )
    def documentReadAction: zio.aws.comprehend.model.DocumentReadAction
    def documentReadMode: Optional[zio.aws.comprehend.model.DocumentReadMode]
    def featureTypes
        : Optional[List[zio.aws.comprehend.model.DocumentReadFeatureTypes]]
    def getDocumentReadAction
        : ZIO[Any, Nothing, zio.aws.comprehend.model.DocumentReadAction] =
      ZIO.succeed(documentReadAction)
    def getDocumentReadMode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DocumentReadMode] =
      AwsError.unwrapOptionField("documentReadMode", documentReadMode)
    def getFeatureTypes: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentReadFeatureTypes
    ]] = AwsError.unwrapOptionField("featureTypes", featureTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig
  ) extends zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly {
    override val documentReadAction
        : zio.aws.comprehend.model.DocumentReadAction =
      zio.aws.comprehend.model.DocumentReadAction
        .wrap(impl.documentReadAction())
    override val documentReadMode
        : Optional[zio.aws.comprehend.model.DocumentReadMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentReadMode())
        .map(value => zio.aws.comprehend.model.DocumentReadMode.wrap(value))
    override val featureTypes
        : Optional[List[zio.aws.comprehend.model.DocumentReadFeatureTypes]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.featureTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.DocumentReadFeatureTypes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentReaderConfig
  ): zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly = new Wrapper(impl)
}
