package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WarningsListItem(
    page: Optional[Integer] = Optional.Absent,
    warnCode: Optional[zio.aws.comprehend.model.PageBasedWarningCode] =
      Optional.Absent,
    warnMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.WarningsListItem = {
    import WarningsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.WarningsListItem
      .builder()
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .optionallyWith(warnCode.map(value => value.unwrap))(_.warnCode)
      .optionallyWith(warnMessage.map(value => value: java.lang.String))(
        _.warnMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.WarningsListItem.ReadOnly =
    zio.aws.comprehend.model.WarningsListItem.wrap(buildAwsValue())
}
object WarningsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.WarningsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.WarningsListItem =
      zio.aws.comprehend.model.WarningsListItem(
        page.map(value => value),
        warnCode.map(value => value),
        warnMessage.map(value => value)
      )
    def page: Optional[Integer]
    def warnCode: Optional[zio.aws.comprehend.model.PageBasedWarningCode]
    def warnMessage: Optional[String]
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
    def getWarnCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.PageBasedWarningCode] =
      AwsError.unwrapOptionField("warnCode", warnCode)
    def getWarnMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warnMessage", warnMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.WarningsListItem
  ) extends zio.aws.comprehend.model.WarningsListItem.ReadOnly {
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
    override val warnCode
        : Optional[zio.aws.comprehend.model.PageBasedWarningCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnCode())
        .map(value => zio.aws.comprehend.model.PageBasedWarningCode.wrap(value))
    override val warnMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.warnMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.WarningsListItem
  ): zio.aws.comprehend.model.WarningsListItem.ReadOnly = new Wrapper(impl)
}
