package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendModelArn,
  ComprehendFlywheelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateFlywheelResponse(
    flywheelArn: Optional[ComprehendFlywheelArn] = Optional.Absent,
    activeModelArn: Optional[ComprehendModelArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse = {
    import CreateFlywheelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse
      .builder()
      .optionallyWith(
        flywheelArn.map(value =>
          ComprehendFlywheelArn.unwrap(value): java.lang.String
        )
      )(_.flywheelArn)
      .optionallyWith(
        activeModelArn.map(value =>
          ComprehendModelArn.unwrap(value): java.lang.String
        )
      )(_.activeModelArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateFlywheelResponse.ReadOnly =
    zio.aws.comprehend.model.CreateFlywheelResponse.wrap(buildAwsValue())
}
object CreateFlywheelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateFlywheelResponse =
      zio.aws.comprehend.model.CreateFlywheelResponse(
        flywheelArn.map(value => value),
        activeModelArn.map(value => value)
      )
    def flywheelArn: Optional[ComprehendFlywheelArn]
    def activeModelArn: Optional[ComprehendModelArn]
    def getFlywheelArn: ZIO[Any, AwsError, ComprehendFlywheelArn] =
      AwsError.unwrapOptionField("flywheelArn", flywheelArn)
    def getActiveModelArn: ZIO[Any, AwsError, ComprehendModelArn] =
      AwsError.unwrapOptionField("activeModelArn", activeModelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse
  ) extends zio.aws.comprehend.model.CreateFlywheelResponse.ReadOnly {
    override val flywheelArn: Optional[ComprehendFlywheelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendFlywheelArn(value)
        )
    override val activeModelArn: Optional[ComprehendModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeModelArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendModelArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateFlywheelResponse
  ): zio.aws.comprehend.model.CreateFlywheelResponse.ReadOnly = new Wrapper(
    impl
  )
}
