package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDetectTargetedSentimentItemResult(
    index: Optional[Integer] = Optional.Absent,
    entities: Optional[
      Iterable[zio.aws.comprehend.model.TargetedSentimentEntity]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentItemResult = {
    import BatchDetectTargetedSentimentItemResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentItemResult
      .builder()
      .optionallyWith(index.map(value => value: java.lang.Integer))(_.index)
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly =
    zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult
      .wrap(buildAwsValue())
}
object BatchDetectTargetedSentimentItemResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentItemResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult =
      zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult(
        index.map(value => value),
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def index: Optional[Integer]
    def entities: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly]
    ]
    def getIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("index", index)
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentItemResult
  ) extends zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly {
    override val index: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => value: Integer)
    override val entities: Optional[
      List[zio.aws.comprehend.model.TargetedSentimentEntity.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.TargetedSentimentEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectTargetedSentimentItemResult
  ): zio.aws.comprehend.model.BatchDetectTargetedSentimentItemResult.ReadOnly =
    new Wrapper(impl)
}
