package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BlockReference(
    blockId: Optional[String] = Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent,
    childBlocks: Optional[Iterable[zio.aws.comprehend.model.ChildBlock]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BlockReference = {
    import BlockReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BlockReference
      .builder()
      .optionallyWith(blockId.map(value => value: java.lang.String))(_.blockId)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .optionallyWith(
        childBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.childBlocks)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.BlockReference.ReadOnly =
    zio.aws.comprehend.model.BlockReference.wrap(buildAwsValue())
}
object BlockReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BlockReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BlockReference =
      zio.aws.comprehend.model.BlockReference(
        blockId.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value),
        childBlocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def blockId: Optional[String]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def childBlocks
        : Optional[List[zio.aws.comprehend.model.ChildBlock.ReadOnly]]
    def getBlockId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("blockId", blockId)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
    def getChildBlocks: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.ChildBlock.ReadOnly
    ]] = AwsError.unwrapOptionField("childBlocks", childBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BlockReference
  ) extends zio.aws.comprehend.model.BlockReference.ReadOnly {
    override val blockId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.blockId())
      .map(value => value: String)
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
    override val childBlocks
        : Optional[List[zio.aws.comprehend.model.ChildBlock.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childBlocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.ChildBlock.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BlockReference
  ): zio.aws.comprehend.model.BlockReference.ReadOnly = new Wrapper(impl)
}
