package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait InputFormat {
  def unwrap: software.amazon.awssdk.services.comprehend.model.InputFormat
}
object InputFormat {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.InputFormat
  ): zio.aws.comprehend.model.InputFormat = value match {
    case software.amazon.awssdk.services.comprehend.model.InputFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.InputFormat.ONE_DOC_PER_FILE =>
      val r = ONE_DOC_PER_FILE
      r
    case software.amazon.awssdk.services.comprehend.model.InputFormat.ONE_DOC_PER_LINE =>
      val r = ONE_DOC_PER_LINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.comprehend.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.InputFormat =
      software.amazon.awssdk.services.comprehend.model.InputFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object ONE_DOC_PER_FILE extends zio.aws.comprehend.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.InputFormat =
      software.amazon.awssdk.services.comprehend.model.InputFormat.ONE_DOC_PER_FILE
  }
  case object ONE_DOC_PER_LINE extends zio.aws.comprehend.model.InputFormat {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.InputFormat =
      software.amazon.awssdk.services.comprehend.model.InputFormat.ONE_DOC_PER_LINE
  }
}
