package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorsListItem(
    page: Optional[Integer] = Optional.Absent,
    errorCode: Optional[zio.aws.comprehend.model.PageBasedErrorCode] =
      Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ErrorsListItem = {
    import ErrorsListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ErrorsListItem
      .builder()
      .optionallyWith(page.map(value => value: java.lang.Integer))(_.page)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ErrorsListItem.ReadOnly =
    zio.aws.comprehend.model.ErrorsListItem.wrap(buildAwsValue())
}
object ErrorsListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ErrorsListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ErrorsListItem =
      zio.aws.comprehend.model.ErrorsListItem(
        page.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def page: Optional[Integer]
    def errorCode: Optional[zio.aws.comprehend.model.PageBasedErrorCode]
    def errorMessage: Optional[String]
    def getPage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("page", page)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.comprehend.model.PageBasedErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ErrorsListItem
  ) extends zio.aws.comprehend.model.ErrorsListItem.ReadOnly {
    override val page: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.page())
      .map(value => value: Integer)
    override val errorCode
        : Optional[zio.aws.comprehend.model.PageBasedErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.comprehend.model.PageBasedErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ErrorsListItem
  ): zio.aws.comprehend.model.ErrorsListItem.ReadOnly = new Wrapper(impl)
}
