package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendEndpointArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEndpointRequest(endpointArn: ComprehendEndpointArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest = {
    import DeleteEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest
      .builder()
      .endpointArn(ComprehendEndpointArn.unwrap(endpointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DeleteEndpointRequest.ReadOnly =
    zio.aws.comprehend.model.DeleteEndpointRequest.wrap(buildAwsValue())
}
object DeleteEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DeleteEndpointRequest =
      zio.aws.comprehend.model.DeleteEndpointRequest(endpointArn)
    def endpointArn: ComprehendEndpointArn
    def getEndpointArn: ZIO[Any, Nothing, ComprehendEndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest
  ) extends zio.aws.comprehend.model.DeleteEndpointRequest.ReadOnly {
    override val endpointArn: ComprehendEndpointArn =
      zio.aws.comprehend.model.primitives
        .ComprehendEndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest
  ): zio.aws.comprehend.model.DeleteEndpointRequest.ReadOnly = new Wrapper(impl)
}
