package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait FlywheelIterationStatus {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus
}
object FlywheelIterationStatus {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus
  ): zio.aws.comprehend.model.FlywheelIterationStatus = value match {
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.TRAINING =>
      val r = TRAINING
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.EVALUATING =>
      val r = EVALUATING
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.STOP_REQUESTED =>
      val r = STOP_REQUESTED
      r
    case software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.STOPPED =>
      val r = STOPPED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object TRAINING
      extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.TRAINING
  }
  case object EVALUATING
      extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.EVALUATING
  }
  case object COMPLETED
      extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.COMPLETED
  }
  case object FAILED extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.FAILED
  }
  case object STOP_REQUESTED
      extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.STOP_REQUESTED
  }
  case object STOPPED extends zio.aws.comprehend.model.FlywheelIterationStatus {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus =
      software.amazon.awssdk.services.comprehend.model.FlywheelIterationStatus.STOPPED
  }
}
