package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateFlywheelResponse(
    flywheelProperties: Optional[zio.aws.comprehend.model.FlywheelProperties] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse = {
    import UpdateFlywheelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse
      .builder()
      .optionallyWith(flywheelProperties.map(value => value.buildAwsValue()))(
        _.flywheelProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.UpdateFlywheelResponse.ReadOnly =
    zio.aws.comprehend.model.UpdateFlywheelResponse.wrap(buildAwsValue())
}
object UpdateFlywheelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.UpdateFlywheelResponse =
      zio.aws.comprehend.model.UpdateFlywheelResponse(
        flywheelProperties.map(value => value.asEditable)
      )
    def flywheelProperties
        : Optional[zio.aws.comprehend.model.FlywheelProperties.ReadOnly]
    def getFlywheelProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.FlywheelProperties.ReadOnly
    ] = AwsError.unwrapOptionField("flywheelProperties", flywheelProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse
  ) extends zio.aws.comprehend.model.UpdateFlywheelResponse.ReadOnly {
    override val flywheelProperties
        : Optional[zio.aws.comprehend.model.FlywheelProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flywheelProperties())
        .map(value => zio.aws.comprehend.model.FlywheelProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.UpdateFlywheelResponse
  ): zio.aws.comprehend.model.UpdateFlywheelResponse.ReadOnly = new Wrapper(
    impl
  )
}
