package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DocumentMetadata(
    pages: Optional[Integer] = Optional.Absent,
    extractedCharacters: Optional[
      Iterable[zio.aws.comprehend.model.ExtractedCharactersListItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentMetadata = {
    import DocumentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentMetadata
      .builder()
      .optionallyWith(pages.map(value => value: java.lang.Integer))(_.pages)
      .optionallyWith(
        extractedCharacters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extractedCharacters)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentMetadata.ReadOnly =
    zio.aws.comprehend.model.DocumentMetadata.wrap(buildAwsValue())
}
object DocumentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentMetadata =
      zio.aws.comprehend.model.DocumentMetadata(
        pages.map(value => value),
        extractedCharacters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pages: Optional[Integer]
    def extractedCharacters: Optional[
      List[zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly]
    ]
    def getPages: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pages", pages)
    def getExtractedCharacters: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly
    ]] = AwsError.unwrapOptionField("extractedCharacters", extractedCharacters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentMetadata
  ) extends zio.aws.comprehend.model.DocumentMetadata.ReadOnly {
    override val pages: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.pages())
      .map(value => value: Integer)
    override val extractedCharacters: Optional[
      List[zio.aws.comprehend.model.ExtractedCharactersListItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.extractedCharacters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.ExtractedCharactersListItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentMetadata
  ): zio.aws.comprehend.model.DocumentMetadata.ReadOnly = new Wrapper(impl)
}
