package zio.aws.comprehend.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.{
  ComprehendArnName,
  AnyLengthString,
  S3Uri,
  NumberOfDocuments,
  Timestamp,
  Description,
  ComprehendDatasetArn
}
import scala.jdk.CollectionConverters._
final case class DatasetProperties(
    datasetArn: Optional[ComprehendDatasetArn] = Optional.Absent,
    datasetName: Optional[ComprehendArnName] = Optional.Absent,
    datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      Optional.Absent,
    datasetS3Uri: Optional[S3Uri] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.comprehend.model.DatasetStatus] = Optional.Absent,
    message: Optional[AnyLengthString] = Optional.Absent,
    numberOfDocuments: Optional[NumberOfDocuments] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DatasetProperties = {
    import DatasetProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DatasetProperties
      .builder()
      .optionallyWith(
        datasetArn.map(value =>
          ComprehendDatasetArn.unwrap(value): java.lang.String
        )
      )(_.datasetArn)
      .optionallyWith(
        datasetName.map(value =>
          ComprehendArnName.unwrap(value): java.lang.String
        )
      )(_.datasetName)
      .optionallyWith(datasetType.map(value => value.unwrap))(_.datasetType)
      .optionallyWith(
        datasetS3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.datasetS3Uri)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        numberOfDocuments.map(value =>
          NumberOfDocuments.unwrap(value): java.lang.Long
        )
      )(_.numberOfDocuments)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DatasetProperties.ReadOnly =
    zio.aws.comprehend.model.DatasetProperties.wrap(buildAwsValue())
}
object DatasetProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DatasetProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DatasetProperties =
      zio.aws.comprehend.model.DatasetProperties(
        datasetArn.map(value => value),
        datasetName.map(value => value),
        datasetType.map(value => value),
        datasetS3Uri.map(value => value),
        description.map(value => value),
        status.map(value => value),
        message.map(value => value),
        numberOfDocuments.map(value => value),
        creationTime.map(value => value),
        endTime.map(value => value)
      )
    def datasetArn: Optional[ComprehendDatasetArn]
    def datasetName: Optional[ComprehendArnName]
    def datasetType: Optional[zio.aws.comprehend.model.DatasetType]
    def datasetS3Uri: Optional[S3Uri]
    def description: Optional[Description]
    def status: Optional[zio.aws.comprehend.model.DatasetStatus]
    def message: Optional[AnyLengthString]
    def numberOfDocuments: Optional[NumberOfDocuments]
    def creationTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def getDatasetArn: ZIO[Any, AwsError, ComprehendDatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getDatasetName: ZIO[Any, AwsError, ComprehendArnName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetType
        : ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetType] =
      AwsError.unwrapOptionField("datasetType", datasetType)
    def getDatasetS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("datasetS3Uri", datasetS3Uri)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getNumberOfDocuments: ZIO[Any, AwsError, NumberOfDocuments] =
      AwsError.unwrapOptionField("numberOfDocuments", numberOfDocuments)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetProperties
  ) extends zio.aws.comprehend.model.DatasetProperties.ReadOnly {
    override val datasetArn: Optional[ComprehendDatasetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetArn())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendDatasetArn(value)
        )
    override val datasetName: Optional[ComprehendArnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetName())
        .map(value =>
          zio.aws.comprehend.model.primitives.ComprehendArnName(value)
        )
    override val datasetType: Optional[zio.aws.comprehend.model.DatasetType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datasetType())
        .map(value => zio.aws.comprehend.model.DatasetType.wrap(value))
    override val datasetS3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetS3Uri())
      .map(value => zio.aws.comprehend.model.primitives.S3Uri(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.comprehend.model.primitives.Description(value))
    override val status: Optional[zio.aws.comprehend.model.DatasetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.comprehend.model.DatasetStatus.wrap(value))
    override val message: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val numberOfDocuments: Optional[NumberOfDocuments] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDocuments())
        .map(value =>
          zio.aws.comprehend.model.primitives.NumberOfDocuments(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DatasetProperties
  ): zio.aws.comprehend.model.DatasetProperties.ReadOnly = new Wrapper(impl)
}
