package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  SemiStructuredDocumentBlob,
  DocumentClassifierEndpointArn,
  CustomerInputString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClassifyDocumentRequest(
    text: Optional[CustomerInputString] = Optional.Absent,
    endpointArn: DocumentClassifierEndpointArn,
    bytes: Optional[SemiStructuredDocumentBlob] = Optional.Absent,
    documentReaderConfig: Optional[
      zio.aws.comprehend.model.DocumentReaderConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest = {
    import ClassifyDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
      .builder()
      .optionallyWith(
        text.map(value => CustomerInputString.unwrap(value): java.lang.String)
      )(_.text)
      .endpointArn(
        DocumentClassifierEndpointArn.unwrap(endpointArn): java.lang.String
      )
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .optionallyWith(documentReaderConfig.map(value => value.buildAwsValue()))(
        _.documentReaderConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly =
    zio.aws.comprehend.model.ClassifyDocumentRequest.wrap(buildAwsValue())
}
object ClassifyDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifyDocumentRequest =
      zio.aws.comprehend.model.ClassifyDocumentRequest(
        text.map(value => value),
        endpointArn,
        bytes.map(value => value),
        documentReaderConfig.map(value => value.asEditable)
      )
    def text: Optional[CustomerInputString]
    def endpointArn: DocumentClassifierEndpointArn
    def bytes: Optional[SemiStructuredDocumentBlob]
    def documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly]
    def getText: ZIO[Any, AwsError, CustomerInputString] =
      AwsError.unwrapOptionField("text", text)
    def getEndpointArn: ZIO[Any, Nothing, DocumentClassifierEndpointArn] =
      ZIO.succeed(endpointArn)
    def getBytes: ZIO[Any, AwsError, SemiStructuredDocumentBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getDocumentReaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("documentReaderConfig", documentReaderConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ) extends zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly {
    override val text: Optional[CustomerInputString] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value =>
        zio.aws.comprehend.model.primitives.CustomerInputString(value)
      )
    override val endpointArn: DocumentClassifierEndpointArn =
      zio.aws.comprehend.model.primitives
        .DocumentClassifierEndpointArn(impl.endpointArn())
    override val bytes: Optional[SemiStructuredDocumentBlob] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bytes())
        .map(value =>
          zio.aws.comprehend.model.primitives.SemiStructuredDocumentBlob(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
    override val documentReaderConfig
        : Optional[zio.aws.comprehend.model.DocumentReaderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentReaderConfig())
        .map(value => zio.aws.comprehend.model.DocumentReaderConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest
  ): zio.aws.comprehend.model.ClassifyDocumentRequest.ReadOnly = new Wrapper(
    impl
  )
}
