package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait DocumentType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DocumentType
}
object DocumentType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentType
  ): zio.aws.comprehend.model.DocumentType = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.NATIVE_PDF =>
      val r = NATIVE_PDF
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.SCANNED_PDF =>
      val r = SCANNED_PDF
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.MS_WORD =>
      val r = MS_WORD
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.IMAGE =>
      val r = IMAGE
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.PLAIN_TEXT =>
      val r = PLAIN_TEXT
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.TEXTRACT_DETECT_DOCUMENT_TEXT_JSON =>
      val r = TEXTRACT_DETECT_DOCUMENT_TEXT_JSON
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentType.TEXTRACT_ANALYZE_DOCUMENT_JSON =>
      val r = TEXTRACT_ANALYZE_DOCUMENT_JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.UNKNOWN_TO_SDK_VERSION
  }
  case object NATIVE_PDF extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.NATIVE_PDF
  }
  case object SCANNED_PDF extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.SCANNED_PDF
  }
  case object MS_WORD extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.MS_WORD
  }
  case object IMAGE extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.IMAGE
  }
  case object PLAIN_TEXT extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.PLAIN_TEXT
  }
  case object TEXTRACT_DETECT_DOCUMENT_TEXT_JSON
      extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.TEXTRACT_DETECT_DOCUMENT_TEXT_JSON
  }
  case object TEXTRACT_ANALYZE_DOCUMENT_JSON
      extends zio.aws.comprehend.model.DocumentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentType =
      software.amazon.awssdk.services.comprehend.model.DocumentType.TEXTRACT_ANALYZE_DOCUMENT_JSON
  }
}
