package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.DocumentClassifierArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDocumentClassifierRequest(
    documentClassifierArn: DocumentClassifierArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest = {
    import DeleteDocumentClassifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest
      .builder()
      .documentClassifierArn(
        DocumentClassifierArn.unwrap(documentClassifierArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DeleteDocumentClassifierRequest.ReadOnly =
    zio.aws.comprehend.model.DeleteDocumentClassifierRequest
      .wrap(buildAwsValue())
}
object DeleteDocumentClassifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DeleteDocumentClassifierRequest =
      zio.aws.comprehend.model
        .DeleteDocumentClassifierRequest(documentClassifierArn)
    def documentClassifierArn: DocumentClassifierArn
    def getDocumentClassifierArn: ZIO[Any, Nothing, DocumentClassifierArn] =
      ZIO.succeed(documentClassifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest
  ) extends zio.aws.comprehend.model.DeleteDocumentClassifierRequest.ReadOnly {
    override val documentClassifierArn: DocumentClassifierArn =
      zio.aws.comprehend.model.primitives
        .DocumentClassifierArn(impl.documentClassifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest
  ): zio.aws.comprehend.model.DeleteDocumentClassifierRequest.ReadOnly =
    new Wrapper(impl)
}
