package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetectDominantLanguageRequest(
    textList: Iterable[CustomerInputString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest = {
    import BatchDetectDominantLanguageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest
      .builder()
      .textList(textList.map { item =>
        CustomerInputString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectDominantLanguageRequest.ReadOnly =
    zio.aws.comprehend.model.BatchDetectDominantLanguageRequest
      .wrap(buildAwsValue())
}
object BatchDetectDominantLanguageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectDominantLanguageRequest =
      zio.aws.comprehend.model.BatchDetectDominantLanguageRequest(textList)
    def textList: List[CustomerInputString]
    def getTextList: ZIO[Any, Nothing, List[CustomerInputString]] =
      ZIO.succeed(textList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest
  ) extends zio.aws.comprehend.model.BatchDetectDominantLanguageRequest.ReadOnly {
    override val textList: List[CustomerInputString] = impl
      .textList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.CustomerInputString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest
  ): zio.aws.comprehend.model.BatchDetectDominantLanguageRequest.ReadOnly =
    new Wrapper(impl)
}
