package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEventsDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest = {
    import DescribeEventsDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEventsDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeEventsDetectionJobRequest
      .wrap(buildAwsValue())
}
object DescribeEventsDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeEventsDetectionJobRequest =
      zio.aws.comprehend.model.DescribeEventsDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest
  ) extends zio.aws.comprehend.model.DescribeEventsDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest
  ): zio.aws.comprehend.model.DescribeEventsDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
