package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait PiiEntityType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.PiiEntityType
}
object PiiEntityType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.PiiEntityType
  ): zio.aws.comprehend.model.PiiEntityType = value match {
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.BANK_ACCOUNT_NUMBER =>
      val r = BANK_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.BANK_ROUTING =>
      val r = BANK_ROUTING
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_NUMBER =>
      val r = CREDIT_DEBIT_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_CVV =>
      val r = CREDIT_DEBIT_CVV
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_EXPIRY =>
      val r = CREDIT_DEBIT_EXPIRY
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.PIN =>
      val r = PIN
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.ADDRESS =>
      val r = ADDRESS
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.PHONE =>
      val r = PHONE
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.SSN =>
      val r = SSN
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.DATE_TIME =>
      val r = DATE_TIME
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.PASSPORT_NUMBER =>
      val r = PASSPORT_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.DRIVER_ID =>
      val r = DRIVER_ID
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.URL =>
      val r = URL
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.AGE =>
      val r = AGE
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.USERNAME =>
      val r = USERNAME
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.PASSWORD =>
      val r = PASSWORD
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.AWS_ACCESS_KEY =>
      val r = AWS_ACCESS_KEY
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.AWS_SECRET_KEY =>
      val r = AWS_SECRET_KEY
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.IP_ADDRESS =>
      val r = IP_ADDRESS
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.MAC_ADDRESS =>
      val r = MAC_ADDRESS
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.LICENSE_PLATE =>
      val r = LICENSE_PLATE
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.VEHICLE_IDENTIFICATION_NUMBER =>
      val r = VEHICLE_IDENTIFICATION_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_NATIONAL_INSURANCE_NUMBER =>
      val r = UK_NATIONAL_INSURANCE_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.CA_SOCIAL_INSURANCE_NUMBER =>
      val r = CA_SOCIAL_INSURANCE_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER =>
      val r = US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER =>
      val r = UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_PERMANENT_ACCOUNT_NUMBER =>
      val r = IN_PERMANENT_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_NREGA =>
      val r = IN_NREGA
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.INTERNATIONAL_BANK_ACCOUNT_NUMBER =>
      val r = INTERNATIONAL_BANK_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.SWIFT_CODE =>
      val r = SWIFT_CODE
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_NATIONAL_HEALTH_SERVICE_NUMBER =>
      val r = UK_NATIONAL_HEALTH_SERVICE_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.CA_HEALTH_NUMBER =>
      val r = CA_HEALTH_NUMBER
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_AADHAAR =>
      val r = IN_AADHAAR
      r
    case software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_VOTER_NUMBER =>
      val r = IN_VOTER_NUMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object BANK_ACCOUNT_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.BANK_ACCOUNT_NUMBER
  }
  case object BANK_ROUTING extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.BANK_ROUTING
  }
  case object CREDIT_DEBIT_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_NUMBER
  }
  case object CREDIT_DEBIT_CVV extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_CVV
  }
  case object CREDIT_DEBIT_EXPIRY
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.CREDIT_DEBIT_EXPIRY
  }
  case object PIN extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.PIN
  }
  case object EMAIL extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.EMAIL
  }
  case object ADDRESS extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.ADDRESS
  }
  case object NAME extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.NAME
  }
  case object PHONE extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.PHONE
  }
  case object SSN extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.SSN
  }
  case object DATE_TIME extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.DATE_TIME
  }
  case object PASSPORT_NUMBER extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.PASSPORT_NUMBER
  }
  case object DRIVER_ID extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.DRIVER_ID
  }
  case object URL extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.URL
  }
  case object AGE extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.AGE
  }
  case object USERNAME extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.USERNAME
  }
  case object PASSWORD extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.PASSWORD
  }
  case object AWS_ACCESS_KEY extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.AWS_ACCESS_KEY
  }
  case object AWS_SECRET_KEY extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.AWS_SECRET_KEY
  }
  case object IP_ADDRESS extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.IP_ADDRESS
  }
  case object MAC_ADDRESS extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.MAC_ADDRESS
  }
  case object ALL extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.ALL
  }
  case object LICENSE_PLATE extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.LICENSE_PLATE
  }
  case object VEHICLE_IDENTIFICATION_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.VEHICLE_IDENTIFICATION_NUMBER
  }
  case object UK_NATIONAL_INSURANCE_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_NATIONAL_INSURANCE_NUMBER
  }
  case object CA_SOCIAL_INSURANCE_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.CA_SOCIAL_INSURANCE_NUMBER
  }
  case object US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
  }
  case object UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
  }
  case object IN_PERMANENT_ACCOUNT_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_PERMANENT_ACCOUNT_NUMBER
  }
  case object IN_NREGA extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_NREGA
  }
  case object INTERNATIONAL_BANK_ACCOUNT_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.INTERNATIONAL_BANK_ACCOUNT_NUMBER
  }
  case object SWIFT_CODE extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.SWIFT_CODE
  }
  case object UK_NATIONAL_HEALTH_SERVICE_NUMBER
      extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.UK_NATIONAL_HEALTH_SERVICE_NUMBER
  }
  case object CA_HEALTH_NUMBER extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.CA_HEALTH_NUMBER
  }
  case object IN_AADHAAR extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_AADHAAR
  }
  case object IN_VOTER_NUMBER extends zio.aws.comprehend.model.PiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.PiiEntityType =
      software.amazon.awssdk.services.comprehend.model.PiiEntityType.IN_VOTER_NUMBER
  }
}
