package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MentionSentiment(
    sentiment: Optional[zio.aws.comprehend.model.SentimentType] =
      Optional.Absent,
    sentimentScore: Optional[zio.aws.comprehend.model.SentimentScore] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.MentionSentiment = {
    import MentionSentiment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.MentionSentiment
      .builder()
      .optionallyWith(sentiment.map(value => value.unwrap))(_.sentiment)
      .optionallyWith(sentimentScore.map(value => value.buildAwsValue()))(
        _.sentimentScore
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.MentionSentiment.ReadOnly =
    zio.aws.comprehend.model.MentionSentiment.wrap(buildAwsValue())
}
object MentionSentiment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.MentionSentiment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.MentionSentiment =
      zio.aws.comprehend.model.MentionSentiment(
        sentiment.map(value => value),
        sentimentScore.map(value => value.asEditable)
      )
    def sentiment: Optional[zio.aws.comprehend.model.SentimentType]
    def sentimentScore
        : Optional[zio.aws.comprehend.model.SentimentScore.ReadOnly]
    def getSentiment
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentType] =
      AwsError.unwrapOptionField("sentiment", sentiment)
    def getSentimentScore
        : ZIO[Any, AwsError, zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      AwsError.unwrapOptionField("sentimentScore", sentimentScore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.MentionSentiment
  ) extends zio.aws.comprehend.model.MentionSentiment.ReadOnly {
    override val sentiment: Optional[zio.aws.comprehend.model.SentimentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentiment())
        .map(value => zio.aws.comprehend.model.SentimentType.wrap(value))
    override val sentimentScore
        : Optional[zio.aws.comprehend.model.SentimentScore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sentimentScore())
        .map(value => zio.aws.comprehend.model.SentimentScore.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.MentionSentiment
  ): zio.aws.comprehend.model.MentionSentiment.ReadOnly = new Wrapper(impl)
}
