package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopEventsDetectionJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest = {
    import StopEventsDetectionJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.StopEventsDetectionJobRequest.ReadOnly =
    zio.aws.comprehend.model.StopEventsDetectionJobRequest.wrap(buildAwsValue())
}
object StopEventsDetectionJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.StopEventsDetectionJobRequest =
      zio.aws.comprehend.model.StopEventsDetectionJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest
  ) extends zio.aws.comprehend.model.StopEventsDetectionJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.comprehend.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest
  ): zio.aws.comprehend.model.StopEventsDetectionJobRequest.ReadOnly =
    new Wrapper(impl)
}
