package zio.aws.comprehend.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPiiEntitiesDetectionJobsRequest(
    filter: Optional[zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest = {
    import ListPiiEntitiesDetectionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly =
    zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest
      .wrap(buildAwsValue())
}
object ListPiiEntitiesDetectionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest =
      zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: Optional[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ) extends zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly {
    override val filter: Optional[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.wrap(value)
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ): zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
