package zio.aws.comprehend
import zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.comprehend.model.{
  CreateEndpointRequest,
  BatchDetectDominantLanguageRequest,
  ListDocumentClassifierSummariesRequest,
  StopPiiEntitiesDetectionJobRequest,
  DeleteEntityRecognizerRequest,
  StartKeyPhrasesDetectionJobRequest,
  DeleteEndpointRequest,
  DescribeDocumentClassificationJobRequest,
  DescribeTopicsDetectionJobRequest,
  StopSentimentDetectionJobRequest,
  DetectEntitiesRequest,
  ListEndpointsRequest,
  DescribeDocumentClassifierRequest,
  DescribeEntityRecognizerRequest,
  ClassifyDocumentRequest,
  StopDominantLanguageDetectionJobRequest,
  DetectSyntaxRequest,
  DescribeTargetedSentimentDetectionJobRequest,
  DescribeSentimentDetectionJobRequest,
  DetectSentimentRequest,
  DescribeEventsDetectionJobRequest,
  DescribeDominantLanguageDetectionJobRequest,
  DescribeEntitiesDetectionJobRequest,
  BatchDetectEntitiesRequest,
  PutResourcePolicyRequest,
  DescribePiiEntitiesDetectionJobRequest,
  StartDocumentClassificationJobRequest,
  DetectDominantLanguageRequest,
  UpdateEndpointRequest,
  BatchDetectSentimentRequest,
  ListTargetedSentimentDetectionJobsRequest,
  ListTagsForResourceRequest,
  StartTopicsDetectionJobRequest,
  BatchDetectSyntaxRequest,
  StopTrainingDocumentClassifierRequest,
  DescribeKeyPhrasesDetectionJobRequest,
  ListEventsDetectionJobsRequest,
  DetectPiiEntitiesRequest,
  ListTopicsDetectionJobsRequest,
  ListDominantLanguageDetectionJobsRequest,
  StartEventsDetectionJobRequest,
  StopEntitiesDetectionJobRequest,
  ListEntityRecognizerSummariesRequest,
  BatchDetectKeyPhrasesRequest,
  ImportModelRequest,
  ListEntitiesDetectionJobsRequest,
  StopTargetedSentimentDetectionJobRequest,
  StopTrainingEntityRecognizerRequest,
  ListEntityRecognizersRequest,
  StopKeyPhrasesDetectionJobRequest,
  StartTargetedSentimentDetectionJobRequest,
  CreateDocumentClassifierRequest,
  StartDominantLanguageDetectionJobRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  StartSentimentDetectionJobRequest,
  CreateEntityRecognizerRequest,
  ListSentimentDetectionJobsRequest,
  StartPiiEntitiesDetectionJobRequest,
  DescribeEndpointRequest,
  ListDocumentClassificationJobsRequest,
  DeleteDocumentClassifierRequest,
  ListKeyPhrasesDetectionJobsRequest,
  StopEventsDetectionJobRequest,
  DescribeResourcePolicyRequest,
  StartEntitiesDetectionJobRequest,
  ContainsPiiEntitiesRequest,
  DetectKeyPhrasesRequest,
  ListPiiEntitiesDetectionJobsRequest,
  TagResourceRequest,
  ListDocumentClassifiersRequest
}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.comprehend.ComprehendAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ComprehendMock extends Mock[Comprehend] {
  object ListTargetedSentimentDetectionJobs
      extends Stream[
        ListTargetedSentimentDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
      ]
  object ListTargetedSentimentDetectionJobsPaginated
      extends Effect[
        ListTargetedSentimentDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly
      ]
  object DescribeEntitiesDetectionJob
      extends Effect[
        DescribeEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly
      ]
  object StartSentimentDetectionJob
      extends Effect[
        StartSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartSentimentDetectionJobResponse.ReadOnly
      ]
  object ListTopicsDetectionJobs
      extends Stream[
        ListTopicsDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
      ]
  object ListTopicsDetectionJobsPaginated
      extends Effect[
        ListTopicsDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly
      ]
  object CreateDocumentClassifier
      extends Effect[
        CreateDocumentClassifierRequest,
        AwsError,
        zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly
      ]
  object DescribeDominantLanguageDetectionJob
      extends Effect[
        DescribeDominantLanguageDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly
      ]
  object DescribeEventsDetectionJob
      extends Effect[
        DescribeEventsDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly
      ]
  object StopPiiEntitiesDetectionJob
      extends Effect[
        StopPiiEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly
      ]
  object ListPiiEntitiesDetectionJobs
      extends Stream[
        ListPiiEntitiesDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
      ]
  object ListPiiEntitiesDetectionJobsPaginated
      extends Effect[
        ListPiiEntitiesDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly
      ]
  object DescribeTargetedSentimentDetectionJob
      extends Effect[
        DescribeTargetedSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly
      ]
  object StopEventsDetectionJob
      extends Effect[
        StopEventsDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopEventsDetectionJobResponse.ReadOnly
      ]
  object ContainsPiiEntities
      extends Effect[
        ContainsPiiEntitiesRequest,
        AwsError,
        zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly
      ]
  object DescribeSentimentDetectionJob
      extends Effect[
        DescribeSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly
      ]
  object DescribeEntityRecognizer
      extends Effect[
        DescribeEntityRecognizerRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly
      ]
  object StopSentimentDetectionJob
      extends Effect[
        StopSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopSentimentDetectionJobResponse.ReadOnly
      ]
  object DetectEntities
      extends Effect[
        DetectEntitiesRequest,
        AwsError,
        zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly
      ]
  object PutResourcePolicy
      extends Effect[
        PutResourcePolicyRequest,
        AwsError,
        zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly
      ]
  object DescribeTopicsDetectionJob
      extends Effect[
        DescribeTopicsDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly
      ]
  object StopDominantLanguageDetectionJob
      extends Effect[
        StopDominantLanguageDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.ReadOnly
      ]
  object StartEventsDetectionJob
      extends Effect[
        StartEventsDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartEventsDetectionJobResponse.ReadOnly
      ]
  object BatchDetectEntities
      extends Effect[
        BatchDetectEntitiesRequest,
        AwsError,
        zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly
      ]
  object StartTargetedSentimentDetectionJob
      extends Effect[
        StartTargetedSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.ReadOnly
      ]
  object BatchDetectKeyPhrases
      extends Effect[
        BatchDetectKeyPhrasesRequest,
        AwsError,
        zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly
      ]
  object DeleteEndpoint
      extends Effect[
        DeleteEndpointRequest,
        AwsError,
        zio.aws.comprehend.model.DeleteEndpointResponse.ReadOnly
      ]
  object DetectDominantLanguage
      extends Effect[
        DetectDominantLanguageRequest,
        AwsError,
        zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly
      ]
  object DescribeKeyPhrasesDetectionJob
      extends Effect[
        DescribeKeyPhrasesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly
      ]
  object BatchDetectSentiment
      extends Effect[
        BatchDetectSentimentRequest,
        AwsError,
        zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly
      ]
  object StartTopicsDetectionJob
      extends Effect[
        StartTopicsDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartTopicsDetectionJobResponse.ReadOnly
      ]
  object BatchDetectDominantLanguage
      extends Effect[
        BatchDetectDominantLanguageRequest,
        AwsError,
        zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly
      ]
  object StartKeyPhrasesDetectionJob
      extends Effect[
        StartKeyPhrasesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.ReadOnly
      ]
  object DeleteDocumentClassifier
      extends Effect[
        DeleteDocumentClassifierRequest,
        AwsError,
        zio.aws.comprehend.model.DeleteDocumentClassifierResponse.ReadOnly
      ]
  object StartPiiEntitiesDetectionJob
      extends Effect[
        StartPiiEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.ReadOnly
      ]
  object StartDocumentClassificationJob
      extends Effect[
        StartDocumentClassificationJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly
      ]
  object ClassifyDocument
      extends Effect[
        ClassifyDocumentRequest,
        AwsError,
        zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly
      ]
  object DescribeDocumentClassifier
      extends Effect[
        DescribeDocumentClassifierRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.comprehend.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeEndpoint
      extends Effect[
        DescribeEndpointRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly
      ]
  object ListDocumentClassifierSummaries
      extends Stream[
        ListDocumentClassifierSummariesRequest,
        AwsError,
        zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
      ]
  object ListDocumentClassifierSummariesPaginated
      extends Effect[
        ListDocumentClassifierSummariesRequest,
        AwsError,
        zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly
      ]
  object ListKeyPhrasesDetectionJobs
      extends Stream[
        ListKeyPhrasesDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
      ]
  object ListKeyPhrasesDetectionJobsPaginated
      extends Effect[
        ListKeyPhrasesDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly
      ]
  object StopEntitiesDetectionJob
      extends Effect[
        StopEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.ReadOnly
      ]
  object ListSentimentDetectionJobs
      extends Stream[
        ListSentimentDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
      ]
  object ListSentimentDetectionJobsPaginated
      extends Effect[
        ListSentimentDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly
      ]
  object StopTargetedSentimentDetectionJob
      extends Effect[
        StopTargetedSentimentDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly
      ]
  object ListDocumentClassificationJobs
      extends Stream[
        ListDocumentClassificationJobsRequest,
        AwsError,
        zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
      ]
  object ListDocumentClassificationJobsPaginated
      extends Effect[
        ListDocumentClassificationJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly
      ]
  object DeleteResourcePolicy
      extends Effect[
        DeleteResourcePolicyRequest,
        AwsError,
        zio.aws.comprehend.model.DeleteResourcePolicyResponse.ReadOnly
      ]
  object StopTrainingEntityRecognizer
      extends Effect[
        StopTrainingEntityRecognizerRequest,
        AwsError,
        zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.comprehend.model.TagResourceResponse.ReadOnly
      ]
  object CreateEndpoint
      extends Effect[
        CreateEndpointRequest,
        AwsError,
        zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly
      ]
  object StopKeyPhrasesDetectionJob
      extends Effect[
        StopKeyPhrasesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.ReadOnly
      ]
  object DetectSentiment
      extends Effect[
        DetectSentimentRequest,
        AwsError,
        zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly
      ]
  object UpdateEndpoint
      extends Effect[
        UpdateEndpointRequest,
        AwsError,
        zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly
      ]
  object ListEndpoints
      extends Stream[
        ListEndpointsRequest,
        AwsError,
        zio.aws.comprehend.model.EndpointProperties.ReadOnly
      ]
  object ListEndpointsPaginated
      extends Effect[
        ListEndpointsRequest,
        AwsError,
        zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly
      ]
  object ImportModel
      extends Effect[
        ImportModelRequest,
        AwsError,
        zio.aws.comprehend.model.ImportModelResponse.ReadOnly
      ]
  object StartEntitiesDetectionJob
      extends Effect[
        StartEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly
      ]
  object CreateEntityRecognizer
      extends Effect[
        CreateEntityRecognizerRequest,
        AwsError,
        zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly
      ]
  object DescribeResourcePolicy
      extends Effect[
        DescribeResourcePolicyRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly
      ]
  object ListEventsDetectionJobs
      extends Stream[
        ListEventsDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
      ]
  object ListEventsDetectionJobsPaginated
      extends Effect[
        ListEventsDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly
      ]
  object ListDocumentClassifiers
      extends Stream[
        ListDocumentClassifiersRequest,
        AwsError,
        zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
      ]
  object ListDocumentClassifiersPaginated
      extends Effect[
        ListDocumentClassifiersRequest,
        AwsError,
        zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly
      ]
  object StartDominantLanguageDetectionJob
      extends Effect[
        StartDominantLanguageDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly
      ]
  object ListEntitiesDetectionJobs
      extends Stream[
        ListEntitiesDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
      ]
  object ListEntitiesDetectionJobsPaginated
      extends Effect[ListEntitiesDetectionJobsRequest, AwsError, ReadOnly]
  object ListDominantLanguageDetectionJobs
      extends Stream[
        ListDominantLanguageDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
      ]
  object ListDominantLanguageDetectionJobsPaginated
      extends Effect[
        ListDominantLanguageDetectionJobsRequest,
        AwsError,
        zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly
      ]
  object DetectPiiEntities
      extends Effect[
        DetectPiiEntitiesRequest,
        AwsError,
        zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly
      ]
  object DeleteEntityRecognizer
      extends Effect[
        DeleteEntityRecognizerRequest,
        AwsError,
        zio.aws.comprehend.model.DeleteEntityRecognizerResponse.ReadOnly
      ]
  object DescribePiiEntitiesDetectionJob
      extends Effect[
        DescribePiiEntitiesDetectionJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly
      ]
  object DetectSyntax
      extends Effect[
        DetectSyntaxRequest,
        AwsError,
        zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly
      ]
  object ListEntityRecognizers
      extends Stream[
        ListEntityRecognizersRequest,
        AwsError,
        zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
      ]
  object ListEntityRecognizersPaginated
      extends Effect[
        ListEntityRecognizersRequest,
        AwsError,
        zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly
      ]
  object BatchDetectSyntax
      extends Effect[
        BatchDetectSyntaxRequest,
        AwsError,
        zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly
      ]
  object StopTrainingDocumentClassifier
      extends Effect[
        StopTrainingDocumentClassifierRequest,
        AwsError,
        zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.ReadOnly
      ]
  object DescribeDocumentClassificationJob
      extends Effect[
        DescribeDocumentClassificationJobRequest,
        AwsError,
        zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly
      ]
  object ListEntityRecognizerSummaries
      extends Stream[
        ListEntityRecognizerSummariesRequest,
        AwsError,
        zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
      ]
  object ListEntityRecognizerSummariesPaginated
      extends Effect[
        ListEntityRecognizerSummariesRequest,
        AwsError,
        zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly
      ]
  object DetectKeyPhrases
      extends Effect[
        DetectKeyPhrasesRequest,
        AwsError,
        zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Comprehend] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Comprehend] { rts =>
        zio.ZIO.succeed {
          new Comprehend {
            val api: ComprehendAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Comprehend = this
            def listTargetedSentimentDetectionJobs(
                request: ListTargetedSentimentDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTargetedSentimentDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTargetedSentimentDetectionJobsPaginated(
                request: ListTargetedSentimentDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly
            ] = proxy(ListTargetedSentimentDetectionJobsPaginated, request)
            def describeEntitiesDetectionJob(
                request: DescribeEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(DescribeEntitiesDetectionJob, request)
            def startSentimentDetectionJob(
                request: StartSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartSentimentDetectionJobResponse.ReadOnly
            ] = proxy(StartSentimentDetectionJob, request)
            def listTopicsDetectionJobs(
                request: ListTopicsDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTopicsDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTopicsDetectionJobsPaginated(
                request: ListTopicsDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly
            ] = proxy(ListTopicsDetectionJobsPaginated, request)
            def createDocumentClassifier(
                request: CreateDocumentClassifierRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly
            ] = proxy(CreateDocumentClassifier, request)
            def describeDominantLanguageDetectionJob(
                request: DescribeDominantLanguageDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly
            ] = proxy(DescribeDominantLanguageDetectionJob, request)
            def describeEventsDetectionJob(
                request: DescribeEventsDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly
            ] = proxy(DescribeEventsDetectionJob, request)
            def stopPiiEntitiesDetectionJob(
                request: StopPiiEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(StopPiiEntitiesDetectionJob, request)
            def listPiiEntitiesDetectionJobs(
                request: ListPiiEntitiesDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPiiEntitiesDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPiiEntitiesDetectionJobsPaginated(
                request: ListPiiEntitiesDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly
            ] = proxy(ListPiiEntitiesDetectionJobsPaginated, request)
            def describeTargetedSentimentDetectionJob(
                request: DescribeTargetedSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly
            ] = proxy(DescribeTargetedSentimentDetectionJob, request)
            def stopEventsDetectionJob(
                request: StopEventsDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopEventsDetectionJobResponse.ReadOnly
            ] = proxy(StopEventsDetectionJob, request)
            def containsPiiEntities(request: ContainsPiiEntitiesRequest): IO[
              AwsError,
              zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly
            ] = proxy(ContainsPiiEntities, request)
            def describeSentimentDetectionJob(
                request: DescribeSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly
            ] = proxy(DescribeSentimentDetectionJob, request)
            def describeEntityRecognizer(
                request: DescribeEntityRecognizerRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly
            ] = proxy(DescribeEntityRecognizer, request)
            def stopSentimentDetectionJob(
                request: StopSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopSentimentDetectionJobResponse.ReadOnly
            ] = proxy(StopSentimentDetectionJob, request)
            def detectEntities(request: DetectEntitiesRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly
            ] = proxy(DetectEntities, request)
            def putResourcePolicy(request: PutResourcePolicyRequest): IO[
              AwsError,
              zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly
            ] = proxy(PutResourcePolicy, request)
            def describeTopicsDetectionJob(
                request: DescribeTopicsDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly
            ] = proxy(DescribeTopicsDetectionJob, request)
            def stopDominantLanguageDetectionJob(
                request: StopDominantLanguageDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.ReadOnly
            ] = proxy(StopDominantLanguageDetectionJob, request)
            def startEventsDetectionJob(
                request: StartEventsDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartEventsDetectionJobResponse.ReadOnly
            ] = proxy(StartEventsDetectionJob, request)
            def batchDetectEntities(request: BatchDetectEntitiesRequest): IO[
              AwsError,
              zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly
            ] = proxy(BatchDetectEntities, request)
            def startTargetedSentimentDetectionJob(
                request: StartTargetedSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.ReadOnly
            ] = proxy(StartTargetedSentimentDetectionJob, request)
            def batchDetectKeyPhrases(
                request: BatchDetectKeyPhrasesRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly
            ] = proxy(BatchDetectKeyPhrases, request)
            def deleteEndpoint(request: DeleteEndpointRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DeleteEndpointResponse.ReadOnly
            ] = proxy(DeleteEndpoint, request)
            def detectDominantLanguage(
                request: DetectDominantLanguageRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly
            ] = proxy(DetectDominantLanguage, request)
            def describeKeyPhrasesDetectionJob(
                request: DescribeKeyPhrasesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly
            ] = proxy(DescribeKeyPhrasesDetectionJob, request)
            def batchDetectSentiment(request: BatchDetectSentimentRequest): IO[
              AwsError,
              zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly
            ] = proxy(BatchDetectSentiment, request)
            def startTopicsDetectionJob(
                request: StartTopicsDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartTopicsDetectionJobResponse.ReadOnly
            ] = proxy(StartTopicsDetectionJob, request)
            def batchDetectDominantLanguage(
                request: BatchDetectDominantLanguageRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly
            ] = proxy(BatchDetectDominantLanguage, request)
            def startKeyPhrasesDetectionJob(
                request: StartKeyPhrasesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.ReadOnly
            ] = proxy(StartKeyPhrasesDetectionJob, request)
            def deleteDocumentClassifier(
                request: DeleteDocumentClassifierRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DeleteDocumentClassifierResponse.ReadOnly
            ] = proxy(DeleteDocumentClassifier, request)
            def startPiiEntitiesDetectionJob(
                request: StartPiiEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(StartPiiEntitiesDetectionJob, request)
            def startDocumentClassificationJob(
                request: StartDocumentClassificationJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly
            ] = proxy(StartDocumentClassificationJob, request)
            def classifyDocument(request: ClassifyDocumentRequest): IO[
              AwsError,
              zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly
            ] = proxy(ClassifyDocument, request)
            def describeDocumentClassifier(
                request: DescribeDocumentClassifierRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly
            ] = proxy(DescribeDocumentClassifier, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.comprehend.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeEndpoint(request: DescribeEndpointRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly
            ] = proxy(DescribeEndpoint, request)
            def listDocumentClassifierSummaries(
                request: ListDocumentClassifierSummariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDocumentClassifierSummaries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDocumentClassifierSummariesPaginated(
                request: ListDocumentClassifierSummariesRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly
            ] = proxy(ListDocumentClassifierSummariesPaginated, request)
            def listKeyPhrasesDetectionJobs(
                request: ListKeyPhrasesDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKeyPhrasesDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKeyPhrasesDetectionJobsPaginated(
                request: ListKeyPhrasesDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly
            ] = proxy(ListKeyPhrasesDetectionJobsPaginated, request)
            def stopEntitiesDetectionJob(
                request: StopEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(StopEntitiesDetectionJob, request)
            def listSentimentDetectionJobs(
                request: ListSentimentDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSentimentDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSentimentDetectionJobsPaginated(
                request: ListSentimentDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly
            ] = proxy(ListSentimentDetectionJobsPaginated, request)
            def stopTargetedSentimentDetectionJob(
                request: StopTargetedSentimentDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly
            ] = proxy(StopTargetedSentimentDetectionJob, request)
            def listDocumentClassificationJobs(
                request: ListDocumentClassificationJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDocumentClassificationJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDocumentClassificationJobsPaginated(
                request: ListDocumentClassificationJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly
            ] = proxy(ListDocumentClassificationJobsPaginated, request)
            def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DeleteResourcePolicyResponse.ReadOnly
            ] = proxy(DeleteResourcePolicy, request)
            def stopTrainingEntityRecognizer(
                request: StopTrainingEntityRecognizerRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.ReadOnly
            ] = proxy(StopTrainingEntityRecognizer, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.comprehend.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createEndpoint(request: CreateEndpointRequest): IO[
              AwsError,
              zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly
            ] = proxy(CreateEndpoint, request)
            def stopKeyPhrasesDetectionJob(
                request: StopKeyPhrasesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.ReadOnly
            ] = proxy(StopKeyPhrasesDetectionJob, request)
            def detectSentiment(request: DetectSentimentRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly
            ] = proxy(DetectSentiment, request)
            def updateEndpoint(request: UpdateEndpointRequest): IO[
              AwsError,
              zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly
            ] = proxy(UpdateEndpoint, request)
            def listEndpoints(request: ListEndpointsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.EndpointProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEndpoints, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEndpointsPaginated(request: ListEndpointsRequest): IO[
              AwsError,
              zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly
            ] = proxy(ListEndpointsPaginated, request)
            def importModel(request: ImportModelRequest): IO[
              AwsError,
              zio.aws.comprehend.model.ImportModelResponse.ReadOnly
            ] = proxy(ImportModel, request)
            def startEntitiesDetectionJob(
                request: StartEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(StartEntitiesDetectionJob, request)
            def createEntityRecognizer(
                request: CreateEntityRecognizerRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly
            ] = proxy(CreateEntityRecognizer, request)
            def describeResourcePolicy(
                request: DescribeResourcePolicyRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly
            ] = proxy(DescribeResourcePolicy, request)
            def listEventsDetectionJobs(
                request: ListEventsDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventsDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventsDetectionJobsPaginated(
                request: ListEventsDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly
            ] = proxy(ListEventsDetectionJobsPaginated, request)
            def listDocumentClassifiers(
                request: ListDocumentClassifiersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDocumentClassifiers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDocumentClassifiersPaginated(
                request: ListDocumentClassifiersRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly
            ] = proxy(ListDocumentClassifiersPaginated, request)
            def startDominantLanguageDetectionJob(
                request: StartDominantLanguageDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly
            ] = proxy(StartDominantLanguageDetectionJob, request)
            def listEntitiesDetectionJobs(
                request: ListEntitiesDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEntitiesDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEntitiesDetectionJobsPaginated(
                request: ListEntitiesDetectionJobsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListEntitiesDetectionJobsPaginated, request)
            def listDominantLanguageDetectionJobs(
                request: ListDominantLanguageDetectionJobsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDominantLanguageDetectionJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDominantLanguageDetectionJobsPaginated(
                request: ListDominantLanguageDetectionJobsRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly
            ] = proxy(ListDominantLanguageDetectionJobsPaginated, request)
            def detectPiiEntities(request: DetectPiiEntitiesRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly
            ] = proxy(DetectPiiEntities, request)
            def deleteEntityRecognizer(
                request: DeleteEntityRecognizerRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DeleteEntityRecognizerResponse.ReadOnly
            ] = proxy(DeleteEntityRecognizer, request)
            def describePiiEntitiesDetectionJob(
                request: DescribePiiEntitiesDetectionJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly
            ] = proxy(DescribePiiEntitiesDetectionJob, request)
            def detectSyntax(request: DetectSyntaxRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly
            ] = proxy(DetectSyntax, request)
            def listEntityRecognizers(
                request: ListEntityRecognizersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEntityRecognizers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEntityRecognizersPaginated(
                request: ListEntityRecognizersRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly
            ] = proxy(ListEntityRecognizersPaginated, request)
            def batchDetectSyntax(request: BatchDetectSyntaxRequest): IO[
              AwsError,
              zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly
            ] = proxy(BatchDetectSyntax, request)
            def stopTrainingDocumentClassifier(
                request: StopTrainingDocumentClassifierRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.ReadOnly
            ] = proxy(StopTrainingDocumentClassifier, request)
            def describeDocumentClassificationJob(
                request: DescribeDocumentClassificationJobRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly
            ] = proxy(DescribeDocumentClassificationJob, request)
            def listEntityRecognizerSummaries(
                request: ListEntityRecognizerSummariesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEntityRecognizerSummaries, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEntityRecognizerSummariesPaginated(
                request: ListEntityRecognizerSummariesRequest
            ): IO[
              AwsError,
              zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly
            ] = proxy(ListEntityRecognizerSummariesPaginated, request)
            def detectKeyPhrases(request: DetectKeyPhrasesRequest): IO[
              AwsError,
              zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly
            ] = proxy(DetectKeyPhrases, request)
          }
        }
      }
    }
  }
}
