package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{Integer, AnyLengthString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EntityRecognizerMetadataEntityTypesListItem(
    `type`: Optional[AnyLengthString] = Optional.Absent,
    evaluationMetrics: Optional[
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics
    ] = Optional.Absent,
    numberOfTrainMentions: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem = {
    import EntityRecognizerMetadataEntityTypesListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
      .builder()
      .optionallyWith(
        `type`.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(evaluationMetrics.map(value => value.buildAwsValue()))(
        _.evaluationMetrics
      )
      .optionallyWith(
        numberOfTrainMentions.map(value => value: java.lang.Integer)
      )(_.numberOfTrainMentions)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
      .wrap(buildAwsValue())
}
object EntityRecognizerMetadataEntityTypesListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem =
      zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem(
        `type`.map(value => value),
        evaluationMetrics.map(value => value.asEditable),
        numberOfTrainMentions.map(value => value)
      )
    def `type`: Optional[AnyLengthString]
    def evaluationMetrics: Optional[
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly
    ]
    def numberOfTrainMentions: Optional[Integer]
    def getType: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("type", `type`)
    def getEvaluationMetrics: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly
    ] = AwsError.unwrapOptionField("evaluationMetrics", evaluationMetrics)
    def getNumberOfTrainMentions: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfTrainMentions", numberOfTrainMentions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ) extends zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly {
    override val `type`: Optional[AnyLengthString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val evaluationMetrics: Optional[
      zio.aws.comprehend.model.EntityTypesEvaluationMetrics.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.evaluationMetrics())
      .map(value =>
        zio.aws.comprehend.model.EntityTypesEvaluationMetrics.wrap(value)
      )
    override val numberOfTrainMentions: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfTrainMentions())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerMetadataEntityTypesListItem
  ): zio.aws.comprehend.model.EntityRecognizerMetadataEntityTypesListItem.ReadOnly =
    new Wrapper(impl)
}
