package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetectDominantLanguageResponse(
    resultList: Iterable[
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult
    ],
    errorList: Iterable[zio.aws.comprehend.model.BatchItemError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse = {
    import BatchDetectDominantLanguageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse
      .builder()
      .resultList(resultList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .errorList(errorList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly =
    zio.aws.comprehend.model.BatchDetectDominantLanguageResponse
      .wrap(buildAwsValue())
}
object BatchDetectDominantLanguageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.BatchDetectDominantLanguageResponse =
      zio.aws.comprehend.model.BatchDetectDominantLanguageResponse(
        resultList.map { item =>
          item.asEditable
        },
        errorList.map { item =>
          item.asEditable
        }
      )
    def resultList: List[
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly
    ]
    def errorList: List[zio.aws.comprehend.model.BatchItemError.ReadOnly]
    def getResultList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly
    ]] = ZIO.succeed(resultList)
    def getErrorList: ZIO[Any, Nothing, List[
      zio.aws.comprehend.model.BatchItemError.ReadOnly
    ]] = ZIO.succeed(errorList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse
  ) extends zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly {
    override val resultList: List[
      zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult.ReadOnly
    ] = impl
      .resultList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchDetectDominantLanguageItemResult
          .wrap(item)
      }
      .toList
    override val errorList
        : List[zio.aws.comprehend.model.BatchItemError.ReadOnly] = impl
      .errorList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.BatchItemError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageResponse
  ): zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly =
    new Wrapper(impl)
}
