package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.MaskCharacter
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RedactionConfig(
    piiEntityTypes: Optional[Iterable[zio.aws.comprehend.model.PiiEntityType]] =
      Optional.Absent,
    maskMode: Optional[zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode] =
      Optional.Absent,
    maskCharacter: Optional[MaskCharacter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.RedactionConfig = {
    import RedactionConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.RedactionConfig
      .builder()
      .optionallyWith(
        piiEntityTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.piiEntityTypesWithStrings)
      .optionallyWith(maskMode.map(value => value.unwrap))(_.maskMode)
      .optionallyWith(
        maskCharacter.map(value =>
          MaskCharacter.unwrap(value): java.lang.String
        )
      )(_.maskCharacter)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.RedactionConfig.ReadOnly =
    zio.aws.comprehend.model.RedactionConfig.wrap(buildAwsValue())
}
object RedactionConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.RedactionConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.RedactionConfig =
      zio.aws.comprehend.model.RedactionConfig(
        piiEntityTypes.map(value => value),
        maskMode.map(value => value),
        maskCharacter.map(value => value)
      )
    def piiEntityTypes: Optional[List[zio.aws.comprehend.model.PiiEntityType]]
    def maskMode
        : Optional[zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode]
    def maskCharacter: Optional[MaskCharacter]
    def getPiiEntityTypes
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.PiiEntityType]] =
      AwsError.unwrapOptionField("piiEntityTypes", piiEntityTypes)
    def getMaskMode: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode
    ] = AwsError.unwrapOptionField("maskMode", maskMode)
    def getMaskCharacter: ZIO[Any, AwsError, MaskCharacter] =
      AwsError.unwrapOptionField("maskCharacter", maskCharacter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.RedactionConfig
  ) extends zio.aws.comprehend.model.RedactionConfig.ReadOnly {
    override val piiEntityTypes
        : Optional[List[zio.aws.comprehend.model.PiiEntityType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.piiEntityTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.PiiEntityType.wrap(item)
          }.toList
        )
    override val maskMode
        : Optional[zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maskMode())
        .map(value =>
          zio.aws.comprehend.model.PiiEntitiesDetectionMaskMode.wrap(value)
        )
    override val maskCharacter: Optional[MaskCharacter] = zio.aws.core.internal
      .optionalFromNullable(impl.maskCharacter())
      .map(value => zio.aws.comprehend.model.primitives.MaskCharacter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.RedactionConfig
  ): zio.aws.comprehend.model.RedactionConfig.ReadOnly = new Wrapper(impl)
}
