package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListDominantLanguageDetectionJobsResponse(
    dominantLanguageDetectionJobPropertiesList: Optional[
      Iterable[zio.aws.comprehend.model.DominantLanguageDetectionJobProperties]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse = {
    import ListDominantLanguageDetectionJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
      .builder()
      .optionallyWith(
        dominantLanguageDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dominantLanguageDetectionJobPropertiesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly =
    zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse
      .wrap(buildAwsValue())
}
object ListDominantLanguageDetectionJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse =
      zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse(
        dominantLanguageDetectionJobPropertiesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dominantLanguageDetectionJobPropertiesList: Optional[List[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ]]
    def nextToken: Optional[String]
    def getDominantLanguageDetectionJobPropertiesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dominantLanguageDetectionJobPropertiesList",
      dominantLanguageDetectionJobPropertiesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
  ) extends zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly {
    override val dominantLanguageDetectionJobPropertiesList: Optional[List[
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dominantLanguageDetectionJobPropertiesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DominantLanguageDetectionJobProperties
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsResponse
  ): zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly =
    new Wrapper(impl)
}
