package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait DocumentReadAction {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.DocumentReadAction
}
object DocumentReadAction {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentReadAction
  ): zio.aws.comprehend.model.DocumentReadAction = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentReadAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadAction.TEXTRACT_DETECT_DOCUMENT_TEXT =>
      val r = TEXTRACT_DETECT_DOCUMENT_TEXT
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadAction.TEXTRACT_ANALYZE_DOCUMENT =>
      val r = TEXTRACT_ANALYZE_DOCUMENT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentReadAction {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadAction =
      software.amazon.awssdk.services.comprehend.model.DocumentReadAction.UNKNOWN_TO_SDK_VERSION
  }
  case object TEXTRACT_DETECT_DOCUMENT_TEXT
      extends zio.aws.comprehend.model.DocumentReadAction {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadAction =
      software.amazon.awssdk.services.comprehend.model.DocumentReadAction.TEXTRACT_DETECT_DOCUMENT_TEXT
  }
  case object TEXTRACT_ANALYZE_DOCUMENT
      extends zio.aws.comprehend.model.DocumentReadAction {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadAction =
      software.amazon.awssdk.services.comprehend.model.DocumentReadAction.TEXTRACT_ANALYZE_DOCUMENT
  }
}
