package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeKeyPhrasesDetectionJobResponse(
    keyPhrasesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse = {
    import DescribeKeyPhrasesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
      .builder()
      .optionallyWith(
        keyPhrasesDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.keyPhrasesDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeKeyPhrasesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse =
      zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse(
        keyPhrasesDetectionJobProperties.map(value => value.asEditable)
      )
    def keyPhrasesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
    ]
    def getKeyPhrasesDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "keyPhrasesDetectionJobProperties",
      keyPhrasesDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly {
    override val keyPhrasesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keyPhrasesDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
