package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  ComprehendArnName,
  ClientRequestTokenString,
  IamRoleArn,
  Policy,
  KmsKeyId,
  VersionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEntityRecognizerRequest(
    recognizerName: ComprehendArnName,
    versionName: Optional[VersionName] = Optional.Absent,
    dataAccessRoleArn: IamRoleArn,
    tags: Optional[Iterable[zio.aws.comprehend.model.Tag]] = Optional.Absent,
    inputDataConfig: zio.aws.comprehend.model.EntityRecognizerInputDataConfig,
    clientRequestToken: Optional[ClientRequestTokenString] = Optional.Absent,
    languageCode: zio.aws.comprehend.model.LanguageCode,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig] = Optional.Absent,
    modelKmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    modelPolicy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest = {
    import CreateEntityRecognizerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest
      .builder()
      .recognizerName(
        ComprehendArnName.unwrap(recognizerName): java.lang.String
      )
      .optionallyWith(
        versionName.map(value => VersionName.unwrap(value): java.lang.String)
      )(_.versionName)
      .dataAccessRoleArn(IamRoleArn.unwrap(dataAccessRoleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .languageCode(languageCode.unwrap)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        modelKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.modelKmsKeyId)
      .optionallyWith(
        modelPolicy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.modelPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.CreateEntityRecognizerRequest.ReadOnly =
    zio.aws.comprehend.model.CreateEntityRecognizerRequest.wrap(buildAwsValue())
}
object CreateEntityRecognizerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateEntityRecognizerRequest =
      zio.aws.comprehend.model.CreateEntityRecognizerRequest(
        recognizerName,
        versionName.map(value => value),
        dataAccessRoleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputDataConfig.asEditable,
        clientRequestToken.map(value => value),
        languageCode,
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable),
        modelKmsKeyId.map(value => value),
        modelPolicy.map(value => value)
      )
    def recognizerName: ComprehendArnName
    def versionName: Optional[VersionName]
    def dataAccessRoleArn: IamRoleArn
    def tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def inputDataConfig
        : zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    def clientRequestToken: Optional[ClientRequestTokenString]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def volumeKmsKeyId: Optional[KmsKeyId]
    def vpcConfig: Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def modelKmsKeyId: Optional[KmsKeyId]
    def modelPolicy: Optional[Policy]
    def getRecognizerName: ZIO[Any, Nothing, ComprehendArnName] =
      ZIO.succeed(recognizerName)
    def getVersionName: ZIO[Any, AwsError, VersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDataAccessRoleArn: ZIO[Any, Nothing, IamRoleArn] =
      ZIO.succeed(dataAccessRoleArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getInputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly
    ] = ZIO.succeed(inputDataConfig)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getModelKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("modelKmsKeyId", modelKmsKeyId)
    def getModelPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("modelPolicy", modelPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest
  ) extends zio.aws.comprehend.model.CreateEntityRecognizerRequest.ReadOnly {
    override val recognizerName: ComprehendArnName =
      zio.aws.comprehend.model.primitives
        .ComprehendArnName(impl.recognizerName())
    override val versionName: Optional[VersionName] = zio.aws.core.internal
      .optionalFromNullable(impl.versionName())
      .map(value => zio.aws.comprehend.model.primitives.VersionName(value))
    override val dataAccessRoleArn: IamRoleArn =
      zio.aws.comprehend.model.primitives.IamRoleArn(impl.dataAccessRoleArn())
    override val tags: Optional[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
    override val inputDataConfig
        : zio.aws.comprehend.model.EntityRecognizerInputDataConfig.ReadOnly =
      zio.aws.comprehend.model.EntityRecognizerInputDataConfig
        .wrap(impl.inputDataConfig())
    override val clientRequestToken: Optional[ClientRequestTokenString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
        )
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Optional[zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
    override val modelKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val modelPolicy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.modelPolicy())
      .map(value => zio.aws.comprehend.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest
  ): zio.aws.comprehend.model.CreateEntityRecognizerRequest.ReadOnly =
    new Wrapper(impl)
}
