package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainsPiiEntitiesResponse(
    labels: Optional[Iterable[zio.aws.comprehend.model.EntityLabel]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse = {
    import ContainsPiiEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse
      .builder()
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly =
    zio.aws.comprehend.model.ContainsPiiEntitiesResponse.wrap(buildAwsValue())
}
object ContainsPiiEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ContainsPiiEntitiesResponse =
      zio.aws.comprehend.model.ContainsPiiEntitiesResponse(
        labels.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def labels: Optional[List[zio.aws.comprehend.model.EntityLabel.ReadOnly]]
    def getLabels: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.EntityLabel.ReadOnly
    ]] = AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse
  ) extends zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly {
    override val labels
        : Optional[List[zio.aws.comprehend.model.EntityLabel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.EntityLabel.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesResponse
  ): zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly =
    new Wrapper(impl)
}
