package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.CustomerInputString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetectKeyPhrasesRequest(
    textList: Iterable[CustomerInputString],
    languageCode: zio.aws.comprehend.model.LanguageCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest = {
    import BatchDetectKeyPhrasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest
      .builder()
      .textList(textList.map { item =>
        CustomerInputString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .languageCode(languageCode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.BatchDetectKeyPhrasesRequest.ReadOnly =
    zio.aws.comprehend.model.BatchDetectKeyPhrasesRequest.wrap(buildAwsValue())
}
object BatchDetectKeyPhrasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.BatchDetectKeyPhrasesRequest =
      zio.aws.comprehend.model
        .BatchDetectKeyPhrasesRequest(textList, languageCode)
    def textList: List[CustomerInputString]
    def languageCode: zio.aws.comprehend.model.LanguageCode
    def getTextList: ZIO[Any, Nothing, List[CustomerInputString]] =
      ZIO.succeed(textList)
    def getLanguageCode
        : ZIO[Any, Nothing, zio.aws.comprehend.model.LanguageCode] =
      ZIO.succeed(languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest
  ) extends zio.aws.comprehend.model.BatchDetectKeyPhrasesRequest.ReadOnly {
    override val textList: List[CustomerInputString] = impl
      .textList()
      .asScala
      .map { item =>
        zio.aws.comprehend.model.primitives.CustomerInputString(item)
      }
      .toList
    override val languageCode: zio.aws.comprehend.model.LanguageCode =
      zio.aws.comprehend.model.LanguageCode.wrap(impl.languageCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest
  ): zio.aws.comprehend.model.BatchDetectKeyPhrasesRequest.ReadOnly =
    new Wrapper(impl)
}
