package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Entity(
    score: Optional[Float] = Optional.Absent,
    `type`: Optional[zio.aws.comprehend.model.EntityType] = Optional.Absent,
    text: Optional[String] = Optional.Absent,
    beginOffset: Optional[Integer] = Optional.Absent,
    endOffset: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.Entity = {
    import Entity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.Entity
      .builder()
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.Entity.ReadOnly =
    zio.aws.comprehend.model.Entity.wrap(buildAwsValue())
}
object Entity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.comprehend.model.Entity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.Entity =
      zio.aws.comprehend.model.Entity(
        score.map(value => value),
        `type`.map(value => value),
        text.map(value => value),
        beginOffset.map(value => value),
        endOffset.map(value => value)
      )
    def score: Optional[Float]
    def `type`: Optional[zio.aws.comprehend.model.EntityType]
    def text: Optional[String]
    def beginOffset: Optional[Integer]
    def endOffset: Optional[Integer]
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
    def getType: ZIO[Any, AwsError, zio.aws.comprehend.model.EntityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.Entity
  ) extends zio.aws.comprehend.model.Entity.ReadOnly {
    override val score: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.score())
      .map(value => value: Float)
    override val `type`: Optional[zio.aws.comprehend.model.EntityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.comprehend.model.EntityType.wrap(value))
    override val text: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.text())
      .map(value => value: String)
    override val beginOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.beginOffset())
      .map(value => value: Integer)
    override val endOffset: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endOffset())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.Entity
  ): zio.aws.comprehend.model.Entity.ReadOnly = new Wrapper(impl)
}
