package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait SyntaxLanguageCode {
  def unwrap
      : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode
}
object SyntaxLanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode
  ): zio.aws.comprehend.model.SyntaxLanguageCode = value match {
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.EN =>
      val r = en
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.ES =>
      val r = es
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.FR =>
      val r = fr
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.DE =>
      val r = de
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.IT =>
      val r = it
      r
    case software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.PT =>
      val r = pt
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object en extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.EN
  }
  case object es extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.ES
  }
  case object fr extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.FR
  }
  case object de extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.DE
  }
  case object it extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.IT
  }
  case object pt extends zio.aws.comprehend.model.SyntaxLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode =
      software.amazon.awssdk.services.comprehend.model.SyntaxLanguageCode.PT
  }
}
