package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait SentimentType {
  def unwrap: software.amazon.awssdk.services.comprehend.model.SentimentType
}
object SentimentType {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.SentimentType
  ): zio.aws.comprehend.model.SentimentType = value match {
    case software.amazon.awssdk.services.comprehend.model.SentimentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.SentimentType.POSITIVE =>
      val r = POSITIVE
      r
    case software.amazon.awssdk.services.comprehend.model.SentimentType.NEGATIVE =>
      val r = NEGATIVE
      r
    case software.amazon.awssdk.services.comprehend.model.SentimentType.NEUTRAL =>
      val r = NEUTRAL
      r
    case software.amazon.awssdk.services.comprehend.model.SentimentType.MIXED =>
      val r = MIXED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SentimentType =
      software.amazon.awssdk.services.comprehend.model.SentimentType.UNKNOWN_TO_SDK_VERSION
  }
  case object POSITIVE extends zio.aws.comprehend.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SentimentType =
      software.amazon.awssdk.services.comprehend.model.SentimentType.POSITIVE
  }
  case object NEGATIVE extends zio.aws.comprehend.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SentimentType =
      software.amazon.awssdk.services.comprehend.model.SentimentType.NEGATIVE
  }
  case object NEUTRAL extends zio.aws.comprehend.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SentimentType =
      software.amazon.awssdk.services.comprehend.model.SentimentType.NEUTRAL
  }
  case object MIXED extends zio.aws.comprehend.model.SentimentType {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.SentimentType =
      software.amazon.awssdk.services.comprehend.model.SentimentType.MIXED
  }
}
