package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEntitiesDetectionJobResponse(
    entitiesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse = {
    import DescribeEntitiesDetectionJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
      .builder()
      .optionallyWith(
        entitiesDetectionJobProperties.map(value => value.buildAwsValue())
      )(_.entitiesDetectionJobProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly =
    zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse
      .wrap(buildAwsValue())
}
object DescribeEntitiesDetectionJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse =
      zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse(
        entitiesDetectionJobProperties.map(value => value.asEditable)
      )
    def entitiesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ]
    def getEntitiesDetectionJobProperties: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ] = AwsError.unwrapOptionField(
      "entitiesDetectionJobProperties",
      entitiesDetectionJobProperties
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ) extends zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly {
    override val entitiesDetectionJobProperties: Optional[
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.entitiesDetectionJobProperties())
      .map(value =>
        zio.aws.comprehend.model.EntitiesDetectionJobProperties.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobResponse
  ): zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly =
    new Wrapper(impl)
}
