package zio.aws.comprehend.model
import scala.jdk.CollectionConverters._
sealed trait DocumentReadMode {
  def unwrap: software.amazon.awssdk.services.comprehend.model.DocumentReadMode
}
object DocumentReadMode {
  def wrap(
      value: software.amazon.awssdk.services.comprehend.model.DocumentReadMode
  ): zio.aws.comprehend.model.DocumentReadMode = value match {
    case software.amazon.awssdk.services.comprehend.model.DocumentReadMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadMode.SERVICE_DEFAULT =>
      val r = SERVICE_DEFAULT
      r
    case software.amazon.awssdk.services.comprehend.model.DocumentReadMode.FORCE_DOCUMENT_READ_ACTION =>
      val r = FORCE_DOCUMENT_READ_ACTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.comprehend.model.DocumentReadMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadMode =
      software.amazon.awssdk.services.comprehend.model.DocumentReadMode.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVICE_DEFAULT
      extends zio.aws.comprehend.model.DocumentReadMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadMode =
      software.amazon.awssdk.services.comprehend.model.DocumentReadMode.SERVICE_DEFAULT
  }
  case object FORCE_DOCUMENT_READ_ACTION
      extends zio.aws.comprehend.model.DocumentReadMode {
    override def unwrap
        : software.amazon.awssdk.services.comprehend.model.DocumentReadMode =
      software.amazon.awssdk.services.comprehend.model.DocumentReadMode.FORCE_DOCUMENT_READ_ACTION
  }
}
