package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassifierEvaluationMetrics(
    accuracy: Option[Double] = None,
    precision: Option[Double] = None,
    recall: Option[Double] = None,
    f1Score: Option[Double] = None,
    microPrecision: Option[Double] = None,
    microRecall: Option[Double] = None,
    microF1Score: Option[Double] = None,
    hammingLoss: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics = {
    import ClassifierEvaluationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics
      .builder()
      .optionallyWith(accuracy.map(value => value: java.lang.Double))(
        _.accuracy
      )
      .optionallyWith(precision.map(value => value: java.lang.Double))(
        _.precision
      )
      .optionallyWith(recall.map(value => value: java.lang.Double))(_.recall)
      .optionallyWith(f1Score.map(value => value: java.lang.Double))(_.f1Score)
      .optionallyWith(microPrecision.map(value => value: java.lang.Double))(
        _.microPrecision
      )
      .optionallyWith(microRecall.map(value => value: java.lang.Double))(
        _.microRecall
      )
      .optionallyWith(microF1Score.map(value => value: java.lang.Double))(
        _.microF1Score
      )
      .optionallyWith(hammingLoss.map(value => value: java.lang.Double))(
        _.hammingLoss
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly =
    zio.aws.comprehend.model.ClassifierEvaluationMetrics.wrap(buildAwsValue())
}
object ClassifierEvaluationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.ClassifierEvaluationMetrics =
      zio.aws.comprehend.model.ClassifierEvaluationMetrics(
        accuracy.map(value => value),
        precision.map(value => value),
        recall.map(value => value),
        f1Score.map(value => value),
        microPrecision.map(value => value),
        microRecall.map(value => value),
        microF1Score.map(value => value),
        hammingLoss.map(value => value)
      )
    def accuracy: Option[Double]
    def precision: Option[Double]
    def recall: Option[Double]
    def f1Score: Option[Double]
    def microPrecision: Option[Double]
    def microRecall: Option[Double]
    def microF1Score: Option[Double]
    def hammingLoss: Option[Double]
    def getAccuracy: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("accuracy", accuracy)
    def getPrecision: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("precision", precision)
    def getRecall: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("recall", recall)
    def getF1Score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("f1Score", f1Score)
    def getMicroPrecision: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("microPrecision", microPrecision)
    def getMicroRecall: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("microRecall", microRecall)
    def getMicroF1Score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("microF1Score", microF1Score)
    def getHammingLoss: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("hammingLoss", hammingLoss)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics
  ) extends zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly {
    override val accuracy: Option[Double] =
      scala.Option(impl.accuracy()).map(value => value: Double)
    override val precision: Option[Double] =
      scala.Option(impl.precision()).map(value => value: Double)
    override val recall: Option[Double] =
      scala.Option(impl.recall()).map(value => value: Double)
    override val f1Score: Option[Double] =
      scala.Option(impl.f1Score()).map(value => value: Double)
    override val microPrecision: Option[Double] =
      scala.Option(impl.microPrecision()).map(value => value: Double)
    override val microRecall: Option[Double] =
      scala.Option(impl.microRecall()).map(value => value: Double)
    override val microF1Score: Option[Double] =
      scala.Option(impl.microF1Score()).map(value => value: Double)
    override val hammingLoss: Option[Double] =
      scala.Option(impl.hammingLoss()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ClassifierEvaluationMetrics
  ): zio.aws.comprehend.model.ClassifierEvaluationMetrics.ReadOnly =
    new Wrapper(impl)
}
