package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EntityRecognizerEvaluationMetrics(
    precision: Option[Double] = None,
    recall: Option[Double] = None,
    f1Score: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics = {
    import EntityRecognizerEvaluationMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics
      .builder()
      .optionallyWith(precision.map(value => value: java.lang.Double))(
        _.precision
      )
      .optionallyWith(recall.map(value => value: java.lang.Double))(_.recall)
      .optionallyWith(f1Score.map(value => value: java.lang.Double))(_.f1Score)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly =
    zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics
      .wrap(buildAwsValue())
}
object EntityRecognizerEvaluationMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics =
      zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics(
        precision.map(value => value),
        recall.map(value => value),
        f1Score.map(value => value)
      )
    def precision: Option[Double]
    def recall: Option[Double]
    def f1Score: Option[Double]
    def getPrecision: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("precision", precision)
    def getRecall: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("recall", recall)
    def getF1Score: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("f1Score", f1Score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics
  ) extends zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly {
    override val precision: Option[Double] =
      scala.Option(impl.precision()).map(value => value: Double)
    override val recall: Option[Double] =
      scala.Option(impl.recall()).map(value => value: Double)
    override val f1Score: Option[Double] =
      scala.Option(impl.f1Score()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityRecognizerEvaluationMetrics
  ): zio.aws.comprehend.model.EntityRecognizerEvaluationMetrics.ReadOnly =
    new Wrapper(impl)
}
