package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EntityLabel(
    name: Option[zio.aws.comprehend.model.PiiEntityType] = None,
    score: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.EntityLabel = {
    import EntityLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.EntityLabel
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.EntityLabel.ReadOnly =
    zio.aws.comprehend.model.EntityLabel.wrap(buildAwsValue())
}
object EntityLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.EntityLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.EntityLabel =
      zio.aws.comprehend.model
        .EntityLabel(name.map(value => value), score.map(value => value))
    def name: Option[zio.aws.comprehend.model.PiiEntityType]
    def score: Option[Float]
    def getName: ZIO[Any, AwsError, zio.aws.comprehend.model.PiiEntityType] =
      AwsError.unwrapOptionField("name", name)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.EntityLabel
  ) extends zio.aws.comprehend.model.EntityLabel.ReadOnly {
    override val name: Option[zio.aws.comprehend.model.PiiEntityType] = scala
      .Option(impl.name())
      .map(value => zio.aws.comprehend.model.PiiEntityType.wrap(value))
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.EntityLabel
  ): zio.aws.comprehend.model.EntityLabel.ReadOnly = new Wrapper(impl)
}
