package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.MaxResultsInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPiiEntitiesDetectionJobsRequest(
    filter: Option[zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter] =
      None,
    nextToken: Option[String] = None,
    maxResults: Option[MaxResultsInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest = {
    import ListPiiEntitiesDetectionJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
      .builder()
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly =
    zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest
      .wrap(buildAwsValue())
}
object ListPiiEntitiesDetectionJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest =
      zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest(
        filter.map(value => value.asEditable),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: Option[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ]
    def nextToken: Option[String]
    def maxResults: Option[MaxResultsInteger]
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ) extends zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly {
    override val filter: Option[
      zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        zio.aws.comprehend.model.PiiEntitiesDetectionJobFilter.wrap(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[MaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.comprehend.model.primitives.MaxResultsInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest
  ): zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsRequest.ReadOnly =
    new Wrapper(impl)
}
