package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentLabel(
    name: Option[String] = None,
    score: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentLabel = {
    import DocumentLabel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentLabel
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(score.map(value => value: java.lang.Float))(_.score)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.DocumentLabel.ReadOnly =
    zio.aws.comprehend.model.DocumentLabel.wrap(buildAwsValue())
}
object DocumentLabel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DocumentLabel =
      zio.aws.comprehend.model
        .DocumentLabel(name.map(value => value), score.map(value => value))
    def name: Option[String]
    def score: Option[Float]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getScore: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("score", score)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ) extends zio.aws.comprehend.model.DocumentLabel.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val score: Option[Float] =
      scala.Option(impl.score()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentLabel
  ): zio.aws.comprehend.model.DocumentLabel.ReadOnly = new Wrapper(impl)
}
