package zio.aws.comprehend.model
import java.lang.Integer
import zio.aws.comprehend.model.primitives.{
  ComprehendEndpointName,
  ClientRequestTokenString,
  IamRoleArn,
  ComprehendModelArn,
  InferenceUnitsInteger
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateEndpointRequest(
    endpointName: ComprehendEndpointName,
    modelArn: ComprehendModelArn,
    desiredInferenceUnits: InferenceUnitsInteger,
    clientRequestToken: Option[ClientRequestTokenString] = None,
    tags: Option[Iterable[zio.aws.comprehend.model.Tag]] = None,
    dataAccessRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest = {
    import CreateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest
      .builder()
      .endpointName(
        ComprehendEndpointName.unwrap(endpointName): java.lang.String
      )
      .modelArn(ComprehendModelArn.unwrap(modelArn): java.lang.String)
      .desiredInferenceUnits(
        InferenceUnitsInteger.unwrap(desiredInferenceUnits): Integer
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestTokenString.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.comprehend.model.CreateEndpointRequest.ReadOnly =
    zio.aws.comprehend.model.CreateEndpointRequest.wrap(buildAwsValue())
}
object CreateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.CreateEndpointRequest =
      zio.aws.comprehend.model.CreateEndpointRequest(
        endpointName,
        modelArn,
        desiredInferenceUnits,
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataAccessRoleArn.map(value => value)
      )
    def endpointName: ComprehendEndpointName
    def modelArn: ComprehendModelArn
    def desiredInferenceUnits: InferenceUnitsInteger
    def clientRequestToken: Option[ClientRequestTokenString]
    def tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]]
    def dataAccessRoleArn: Option[IamRoleArn]
    def getEndpointName: ZIO[Any, Nothing, ComprehendEndpointName] =
      ZIO.succeed(endpointName)
    def getModelArn: ZIO[Any, Nothing, ComprehendModelArn] =
      ZIO.succeed(modelArn)
    def getDesiredInferenceUnits: ZIO[Any, Nothing, InferenceUnitsInteger] =
      ZIO.succeed(desiredInferenceUnits)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestTokenString] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest
  ) extends zio.aws.comprehend.model.CreateEndpointRequest.ReadOnly {
    override val endpointName: ComprehendEndpointName =
      zio.aws.comprehend.model.primitives
        .ComprehendEndpointName(impl.endpointName())
    override val modelArn: ComprehendModelArn =
      zio.aws.comprehend.model.primitives.ComprehendModelArn(impl.modelArn())
    override val desiredInferenceUnits: InferenceUnitsInteger =
      zio.aws.comprehend.model.primitives
        .InferenceUnitsInteger(impl.desiredInferenceUnits())
    override val clientRequestToken: Option[ClientRequestTokenString] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.comprehend.model.primitives.ClientRequestTokenString(value)
      )
    override val tags: Option[List[zio.aws.comprehend.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.comprehend.model.Tag.wrap(item)
          }.toList
        )
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest
  ): zio.aws.comprehend.model.CreateEndpointRequest.ReadOnly = new Wrapper(impl)
}
