package zio.aws.comprehend
import zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.comprehend.model.{
  CreateEndpointRequest,
  BatchDetectDominantLanguageRequest,
  ListDocumentClassifierSummariesRequest,
  StopPiiEntitiesDetectionJobRequest,
  DeleteEntityRecognizerRequest,
  StartKeyPhrasesDetectionJobRequest,
  DeleteEndpointRequest,
  DescribeDocumentClassificationJobRequest,
  DescribeTopicsDetectionJobRequest,
  StopSentimentDetectionJobRequest,
  DetectEntitiesRequest,
  ListEndpointsRequest,
  DescribeDocumentClassifierRequest,
  DescribeEntityRecognizerRequest,
  ClassifyDocumentRequest,
  StopDominantLanguageDetectionJobRequest,
  DetectSyntaxRequest,
  DescribeTargetedSentimentDetectionJobRequest,
  DescribeSentimentDetectionJobRequest,
  DetectSentimentRequest,
  DescribeEventsDetectionJobRequest,
  DescribeDominantLanguageDetectionJobRequest,
  DescribeEntitiesDetectionJobRequest,
  BatchDetectEntitiesRequest,
  PutResourcePolicyRequest,
  DescribePiiEntitiesDetectionJobRequest,
  StartDocumentClassificationJobRequest,
  DetectDominantLanguageRequest,
  UpdateEndpointRequest,
  BatchDetectSentimentRequest,
  ListTargetedSentimentDetectionJobsRequest,
  ListTagsForResourceRequest,
  StartTopicsDetectionJobRequest,
  BatchDetectSyntaxRequest,
  StopTrainingDocumentClassifierRequest,
  DescribeKeyPhrasesDetectionJobRequest,
  ListEventsDetectionJobsRequest,
  DetectPiiEntitiesRequest,
  ListTopicsDetectionJobsRequest,
  ListDominantLanguageDetectionJobsRequest,
  StartEventsDetectionJobRequest,
  StopEntitiesDetectionJobRequest,
  ListEntityRecognizerSummariesRequest,
  BatchDetectKeyPhrasesRequest,
  ImportModelRequest,
  ListEntitiesDetectionJobsRequest,
  StopTargetedSentimentDetectionJobRequest,
  StopTrainingEntityRecognizerRequest,
  ListEntityRecognizersRequest,
  StopKeyPhrasesDetectionJobRequest,
  StartTargetedSentimentDetectionJobRequest,
  CreateDocumentClassifierRequest,
  StartDominantLanguageDetectionJobRequest,
  DeleteResourcePolicyRequest,
  UntagResourceRequest,
  StartSentimentDetectionJobRequest,
  CreateEntityRecognizerRequest,
  ListSentimentDetectionJobsRequest,
  StartPiiEntitiesDetectionJobRequest,
  DescribeEndpointRequest,
  ListDocumentClassificationJobsRequest,
  DeleteDocumentClassifierRequest,
  ListKeyPhrasesDetectionJobsRequest,
  StopEventsDetectionJobRequest,
  DescribeResourcePolicyRequest,
  StartEntitiesDetectionJobRequest,
  ContainsPiiEntitiesRequest,
  DetectKeyPhrasesRequest,
  ListPiiEntitiesDetectionJobsRequest,
  TagResourceRequest,
  ListDocumentClassifiersRequest
}
import software.amazon.awssdk.services.comprehend.model.{
  DescribeDocumentClassificationJobResponse,
  DocumentClassificationJobProperties,
  TopicsDetectionJobProperties,
  StopPiiEntitiesDetectionJobResponse,
  ListKeyPhrasesDetectionJobsResponse,
  ImportModelResponse,
  DeleteEndpointResponse,
  PutResourcePolicyResponse,
  UpdateEndpointResponse,
  ListTopicsDetectionJobsResponse,
  EntitiesDetectionJobProperties,
  ListEndpointsResponse,
  StartSentimentDetectionJobResponse,
  DescribeResourcePolicyResponse,
  PiiEntitiesDetectionJobProperties,
  DescribeTargetedSentimentDetectionJobResponse,
  ClassifyDocumentResponse,
  DescribeDocumentClassifierResponse,
  ListDominantLanguageDetectionJobsResponse,
  DescribeDominantLanguageDetectionJobResponse,
  StartKeyPhrasesDetectionJobResponse,
  BatchDetectKeyPhrasesResponse,
  DescribeTopicsDetectionJobResponse,
  StopDominantLanguageDetectionJobResponse,
  BatchDetectSentimentResponse,
  TargetedSentimentDetectionJobProperties,
  StopTargetedSentimentDetectionJobResponse,
  ListTargetedSentimentDetectionJobsResponse,
  DescribeSentimentDetectionJobResponse,
  DetectDominantLanguageResponse,
  DeleteDocumentClassifierResponse,
  StopTrainingDocumentClassifierResponse,
  StartEntitiesDetectionJobResponse,
  EntityRecognizerProperties,
  StopEntitiesDetectionJobResponse,
  ListDocumentClassifierSummariesResponse,
  StopEventsDetectionJobResponse,
  StopTrainingEntityRecognizerResponse,
  DescribeEndpointResponse,
  ListTagsForResourceResponse,
  DescribeEntityRecognizerResponse,
  UntagResourceResponse,
  ListEntityRecognizerSummariesResponse,
  DocumentClassifierSummary,
  ListSentimentDetectionJobsResponse,
  ListDocumentClassifiersResponse,
  DetectEntitiesResponse,
  DeleteEntityRecognizerResponse,
  CreateEntityRecognizerResponse,
  ListEventsDetectionJobsResponse,
  ListPiiEntitiesDetectionJobsResponse,
  DetectSyntaxResponse,
  StartDominantLanguageDetectionJobResponse,
  SentimentDetectionJobProperties,
  DescribePiiEntitiesDetectionJobResponse,
  DescribeKeyPhrasesDetectionJobResponse,
  ContainsPiiEntitiesResponse,
  ListDocumentClassificationJobsResponse,
  EndpointProperties,
  CreateEndpointResponse,
  DominantLanguageDetectionJobProperties,
  CreateDocumentClassifierResponse,
  BatchDetectEntitiesResponse,
  StartTopicsDetectionJobResponse,
  StopKeyPhrasesDetectionJobResponse,
  StartDocumentClassificationJobResponse,
  DocumentClassifierProperties,
  StopSentimentDetectionJobResponse,
  StartEventsDetectionJobResponse,
  BatchDetectDominantLanguageResponse,
  StartTargetedSentimentDetectionJobResponse,
  DetectSentimentResponse,
  DetectPiiEntitiesResponse,
  DeleteResourcePolicyResponse,
  ListEntitiesDetectionJobsResponse,
  DescribeEntitiesDetectionJobResponse,
  DetectKeyPhrasesResponse,
  TagResourceResponse,
  EventsDetectionJobProperties,
  EntityRecognizerSummary,
  StartPiiEntitiesDetectionJobResponse,
  DescribeEventsDetectionJobResponse,
  BatchDetectSyntaxResponse,
  KeyPhrasesDetectionJobProperties,
  ListEntityRecognizersResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.comprehend.{
  ComprehendAsyncClientBuilder,
  ComprehendAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Comprehend extends AspectSupport[Comprehend] {
  val api: ComprehendAsyncClient
  def listTargetedSentimentDetectionJobs(
      request: ListTargetedSentimentDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
  ]
  def listTargetedSentimentDetectionJobsPaginated(
      request: ListTargetedSentimentDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly
  ]
  def describeEntitiesDetectionJob(
      request: DescribeEntitiesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly
  ]
  def startSentimentDetectionJob(
      request: StartSentimentDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartSentimentDetectionJobResponse.ReadOnly
  ]
  def listTopicsDetectionJobs(request: ListTopicsDetectionJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
  ]
  def listTopicsDetectionJobsPaginated(
      request: ListTopicsDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly
  ]
  def createDocumentClassifier(request: CreateDocumentClassifierRequest): IO[
    AwsError,
    zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly
  ]
  def describeDominantLanguageDetectionJob(
      request: DescribeDominantLanguageDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly
  ]
  def describeEventsDetectionJob(
      request: DescribeEventsDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly
  ]
  def stopPiiEntitiesDetectionJob(
      request: StopPiiEntitiesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly
  ]
  def listPiiEntitiesDetectionJobs(
      request: ListPiiEntitiesDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
  ]
  def listPiiEntitiesDetectionJobsPaginated(
      request: ListPiiEntitiesDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly
  ]
  def describeTargetedSentimentDetectionJob(
      request: DescribeTargetedSentimentDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly
  ]
  def stopEventsDetectionJob(request: StopEventsDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StopEventsDetectionJobResponse.ReadOnly
  ]
  def containsPiiEntities(
      request: ContainsPiiEntitiesRequest
  ): IO[AwsError, zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly]
  def describeSentimentDetectionJob(
      request: DescribeSentimentDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly
  ]
  def describeEntityRecognizer(request: DescribeEntityRecognizerRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly
  ]
  def stopSentimentDetectionJob(request: StopSentimentDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StopSentimentDetectionJobResponse.ReadOnly
  ]
  def detectEntities(
      request: DetectEntitiesRequest
  ): IO[AwsError, zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly]
  def putResourcePolicy(
      request: PutResourcePolicyRequest
  ): IO[AwsError, zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly]
  def describeTopicsDetectionJob(
      request: DescribeTopicsDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly
  ]
  def stopDominantLanguageDetectionJob(
      request: StopDominantLanguageDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.ReadOnly
  ]
  def startEventsDetectionJob(request: StartEventsDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StartEventsDetectionJobResponse.ReadOnly
  ]
  def batchDetectEntities(
      request: BatchDetectEntitiesRequest
  ): IO[AwsError, zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly]
  def startTargetedSentimentDetectionJob(
      request: StartTargetedSentimentDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.ReadOnly
  ]
  def batchDetectKeyPhrases(request: BatchDetectKeyPhrasesRequest): IO[
    AwsError,
    zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly
  ]
  def deleteEndpoint(
      request: DeleteEndpointRequest
  ): IO[AwsError, zio.aws.comprehend.model.DeleteEndpointResponse.ReadOnly]
  def detectDominantLanguage(request: DetectDominantLanguageRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly
  ]
  def describeKeyPhrasesDetectionJob(
      request: DescribeKeyPhrasesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly
  ]
  def batchDetectSentiment(request: BatchDetectSentimentRequest): IO[
    AwsError,
    zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly
  ]
  def startTopicsDetectionJob(request: StartTopicsDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StartTopicsDetectionJobResponse.ReadOnly
  ]
  def batchDetectDominantLanguage(
      request: BatchDetectDominantLanguageRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly
  ]
  def startKeyPhrasesDetectionJob(
      request: StartKeyPhrasesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.ReadOnly
  ]
  def deleteDocumentClassifier(request: DeleteDocumentClassifierRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DeleteDocumentClassifierResponse.ReadOnly
  ]
  def startPiiEntitiesDetectionJob(
      request: StartPiiEntitiesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.ReadOnly
  ]
  def startDocumentClassificationJob(
      request: StartDocumentClassificationJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly
  ]
  def classifyDocument(
      request: ClassifyDocumentRequest
  ): IO[AwsError, zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly]
  def describeDocumentClassifier(
      request: DescribeDocumentClassifierRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.comprehend.model.UntagResourceResponse.ReadOnly]
  def describeEndpoint(
      request: DescribeEndpointRequest
  ): IO[AwsError, zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly]
  def listDocumentClassifierSummaries(
      request: ListDocumentClassifierSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
  ]
  def listDocumentClassifierSummariesPaginated(
      request: ListDocumentClassifierSummariesRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly
  ]
  def listKeyPhrasesDetectionJobs(
      request: ListKeyPhrasesDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
  ]
  def listKeyPhrasesDetectionJobsPaginated(
      request: ListKeyPhrasesDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly
  ]
  def stopEntitiesDetectionJob(request: StopEntitiesDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.ReadOnly
  ]
  def listSentimentDetectionJobs(
      request: ListSentimentDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
  ]
  def listSentimentDetectionJobsPaginated(
      request: ListSentimentDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly
  ]
  def stopTargetedSentimentDetectionJob(
      request: StopTargetedSentimentDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly
  ]
  def listDocumentClassificationJobs(
      request: ListDocumentClassificationJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
  ]
  def listDocumentClassificationJobsPaginated(
      request: ListDocumentClassificationJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly
  ]
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DeleteResourcePolicyResponse.ReadOnly
  ]
  def stopTrainingEntityRecognizer(
      request: StopTrainingEntityRecognizerRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.comprehend.model.TagResourceResponse.ReadOnly]
  def createEndpoint(
      request: CreateEndpointRequest
  ): IO[AwsError, zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly]
  def stopKeyPhrasesDetectionJob(
      request: StopKeyPhrasesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.ReadOnly
  ]
  def detectSentiment(
      request: DetectSentimentRequest
  ): IO[AwsError, zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly]
  def updateEndpoint(
      request: UpdateEndpointRequest
  ): IO[AwsError, zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly]
  def listEndpoints(request: ListEndpointsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.EndpointProperties.ReadOnly
  ]
  def listEndpointsPaginated(
      request: ListEndpointsRequest
  ): IO[AwsError, zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly]
  def importModel(
      request: ImportModelRequest
  ): IO[AwsError, zio.aws.comprehend.model.ImportModelResponse.ReadOnly]
  def startEntitiesDetectionJob(request: StartEntitiesDetectionJobRequest): IO[
    AwsError,
    zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly
  ]
  def createEntityRecognizer(request: CreateEntityRecognizerRequest): IO[
    AwsError,
    zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly
  ]
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly
  ]
  def listEventsDetectionJobs(request: ListEventsDetectionJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
  ]
  def listEventsDetectionJobsPaginated(
      request: ListEventsDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly
  ]
  def listDocumentClassifiers(request: ListDocumentClassifiersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
  ]
  def listDocumentClassifiersPaginated(
      request: ListDocumentClassifiersRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly
  ]
  def startDominantLanguageDetectionJob(
      request: StartDominantLanguageDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly
  ]
  def listEntitiesDetectionJobs(
      request: ListEntitiesDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
  ]
  def listEntitiesDetectionJobsPaginated(
      request: ListEntitiesDetectionJobsRequest
  ): IO[AwsError, ReadOnly]
  def listDominantLanguageDetectionJobs(
      request: ListDominantLanguageDetectionJobsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
  ]
  def listDominantLanguageDetectionJobsPaginated(
      request: ListDominantLanguageDetectionJobsRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly
  ]
  def detectPiiEntities(
      request: DetectPiiEntitiesRequest
  ): IO[AwsError, zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly]
  def deleteEntityRecognizer(request: DeleteEntityRecognizerRequest): IO[
    AwsError,
    zio.aws.comprehend.model.DeleteEntityRecognizerResponse.ReadOnly
  ]
  def describePiiEntitiesDetectionJob(
      request: DescribePiiEntitiesDetectionJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly
  ]
  def detectSyntax(
      request: DetectSyntaxRequest
  ): IO[AwsError, zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly]
  def listEntityRecognizers(request: ListEntityRecognizersRequest): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
  ]
  def listEntityRecognizersPaginated(request: ListEntityRecognizersRequest): IO[
    AwsError,
    zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly
  ]
  def batchDetectSyntax(
      request: BatchDetectSyntaxRequest
  ): IO[AwsError, zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly]
  def stopTrainingDocumentClassifier(
      request: StopTrainingDocumentClassifierRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.ReadOnly
  ]
  def describeDocumentClassificationJob(
      request: DescribeDocumentClassificationJobRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly
  ]
  def listEntityRecognizerSummaries(
      request: ListEntityRecognizerSummariesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
  ]
  def listEntityRecognizerSummariesPaginated(
      request: ListEntityRecognizerSummariesRequest
  ): IO[
    AwsError,
    zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly
  ]
  def detectKeyPhrases(
      request: DetectKeyPhrasesRequest
  ): IO[AwsError, zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly]
}
object Comprehend {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Comprehend] = customized(
    identity
  )
  def customized(
      customization: ComprehendAsyncClientBuilder => ComprehendAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Comprehend] = managed(
    customization
  ).toLayer
  def managed(
      customization: ComprehendAsyncClientBuilder => ComprehendAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Comprehend] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ComprehendAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ComprehendAsyncClient, ComprehendAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[ComprehendAsyncClient, ComprehendAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new ComprehendImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class ComprehendImpl[R](
      override val api: ComprehendAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Comprehend
      with AwsServiceBase[R] {
    override val serviceName: String = "Comprehend"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ComprehendImpl[R1] = new ComprehendImpl(api, newAspect, r)
    def listTargetedSentimentDetectionJobs(
        request: ListTargetedSentimentDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest,
      ListTargetedSentimentDetectionJobsResponse,
      TargetedSentimentDetectionJobProperties
    ](
      "listTargetedSentimentDetectionJobs",
      api.listTargetedSentimentDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.targetedSentimentDetectionJobPropertiesList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties
          .wrap(item)
      )
      .provideEnvironment(r)
    def listTargetedSentimentDetectionJobsPaginated(
        request: ListTargetedSentimentDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListTargetedSentimentDetectionJobsRequest,
      ListTargetedSentimentDetectionJobsResponse
    ](
      "listTargetedSentimentDetectionJobs",
      api.listTargetedSentimentDetectionJobs
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.wrap
      )
      .provideEnvironment(r)
    def describeEntitiesDetectionJob(
        request: DescribeEntitiesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeEntitiesDetectionJobRequest,
      DescribeEntitiesDetectionJobResponse
    ]("describeEntitiesDetectionJob", api.describeEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def startSentimentDetectionJob(
        request: StartSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartSentimentDetectionJobRequest,
      StartSentimentDetectionJobResponse
    ]("startSentimentDetectionJob", api.startSentimentDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartSentimentDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def listTopicsDetectionJobs(
        request: ListTopicsDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest,
      ListTopicsDetectionJobsResponse,
      TopicsDetectionJobProperties
    ](
      "listTopicsDetectionJobs",
      api.listTopicsDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.topicsDetectionJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.TopicsDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listTopicsDetectionJobsPaginated(
        request: ListTopicsDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListTopicsDetectionJobsRequest,
      ListTopicsDetectionJobsResponse
    ]("listTopicsDetectionJobs", api.listTopicsDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def createDocumentClassifier(request: CreateDocumentClassifierRequest): IO[
      AwsError,
      zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.CreateDocumentClassifierRequest,
      CreateDocumentClassifierResponse
    ]("createDocumentClassifier", api.createDocumentClassifier)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.CreateDocumentClassifierResponse.wrap)
      .provideEnvironment(r)
    def describeDominantLanguageDetectionJob(
        request: DescribeDominantLanguageDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeDominantLanguageDetectionJobRequest,
      DescribeDominantLanguageDetectionJobResponse
    ](
      "describeDominantLanguageDetectionJob",
      api.describeDominantLanguageDetectionJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.wrap
      )
      .provideEnvironment(r)
    def describeEventsDetectionJob(
        request: DescribeEventsDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeEventsDetectionJobRequest,
      DescribeEventsDetectionJobResponse
    ]("describeEventsDetectionJob", api.describeEventsDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def stopPiiEntitiesDetectionJob(
        request: StopPiiEntitiesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopPiiEntitiesDetectionJobRequest,
      StopPiiEntitiesDetectionJobResponse
    ]("stopPiiEntitiesDetectionJob", api.stopPiiEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def listPiiEntitiesDetectionJobs(
        request: ListPiiEntitiesDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest,
      ListPiiEntitiesDetectionJobsResponse,
      PiiEntitiesDetectionJobProperties
    ](
      "listPiiEntitiesDetectionJobs",
      api.listPiiEntitiesDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.piiEntitiesDetectionJobPropertiesList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listPiiEntitiesDetectionJobsPaginated(
        request: ListPiiEntitiesDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListPiiEntitiesDetectionJobsRequest,
      ListPiiEntitiesDetectionJobsResponse
    ]("listPiiEntitiesDetectionJobs", api.listPiiEntitiesDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def describeTargetedSentimentDetectionJob(
        request: DescribeTargetedSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeTargetedSentimentDetectionJobRequest,
      DescribeTargetedSentimentDetectionJobResponse
    ](
      "describeTargetedSentimentDetectionJob",
      api.describeTargetedSentimentDetectionJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.wrap
      )
      .provideEnvironment(r)
    def stopEventsDetectionJob(request: StopEventsDetectionJobRequest): IO[
      AwsError,
      zio.aws.comprehend.model.StopEventsDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopEventsDetectionJobRequest,
      StopEventsDetectionJobResponse
    ]("stopEventsDetectionJob", api.stopEventsDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopEventsDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def containsPiiEntities(request: ContainsPiiEntitiesRequest): IO[
      AwsError,
      zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ContainsPiiEntitiesRequest,
      ContainsPiiEntitiesResponse
    ]("containsPiiEntities", api.containsPiiEntities)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.ContainsPiiEntitiesResponse.wrap)
      .provideEnvironment(r)
    def describeSentimentDetectionJob(
        request: DescribeSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeSentimentDetectionJobRequest,
      DescribeSentimentDetectionJobResponse
    ]("describeSentimentDetectionJob", api.describeSentimentDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def describeEntityRecognizer(request: DescribeEntityRecognizerRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeEntityRecognizerRequest,
      DescribeEntityRecognizerResponse
    ]("describeEntityRecognizer", api.describeEntityRecognizer)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeEntityRecognizerResponse.wrap)
      .provideEnvironment(r)
    def stopSentimentDetectionJob(
        request: StopSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopSentimentDetectionJobRequest,
      StopSentimentDetectionJobResponse
    ]("stopSentimentDetectionJob", api.stopSentimentDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopSentimentDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def detectEntities(
        request: DetectEntitiesRequest
    ): IO[AwsError, zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.DetectEntitiesRequest,
        DetectEntitiesResponse
      ]("detectEntities", api.detectEntities)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.DetectEntitiesResponse.wrap)
        .provideEnvironment(r)
    def putResourcePolicy(request: PutResourcePolicyRequest): IO[
      AwsError,
      zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.PutResourcePolicyRequest,
      PutResourcePolicyResponse
    ]("putResourcePolicy", api.putResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.PutResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def describeTopicsDetectionJob(
        request: DescribeTopicsDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeTopicsDetectionJobRequest,
      DescribeTopicsDetectionJobResponse
    ]("describeTopicsDetectionJob", api.describeTopicsDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def stopDominantLanguageDetectionJob(
        request: StopDominantLanguageDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopDominantLanguageDetectionJobRequest,
      StopDominantLanguageDetectionJobResponse
    ]("stopDominantLanguageDetectionJob", api.stopDominantLanguageDetectionJob)(
      request.buildAwsValue()
    ).map(
      zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.wrap
    ).provideEnvironment(r)
    def startEventsDetectionJob(request: StartEventsDetectionJobRequest): IO[
      AwsError,
      zio.aws.comprehend.model.StartEventsDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartEventsDetectionJobRequest,
      StartEventsDetectionJobResponse
    ]("startEventsDetectionJob", api.startEventsDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartEventsDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def batchDetectEntities(request: BatchDetectEntitiesRequest): IO[
      AwsError,
      zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.BatchDetectEntitiesRequest,
      BatchDetectEntitiesResponse
    ]("batchDetectEntities", api.batchDetectEntities)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.BatchDetectEntitiesResponse.wrap)
      .provideEnvironment(r)
    def startTargetedSentimentDetectionJob(
        request: StartTargetedSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartTargetedSentimentDetectionJobRequest,
      StartTargetedSentimentDetectionJobResponse
    ](
      "startTargetedSentimentDetectionJob",
      api.startTargetedSentimentDetectionJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.wrap
      )
      .provideEnvironment(r)
    def batchDetectKeyPhrases(request: BatchDetectKeyPhrasesRequest): IO[
      AwsError,
      zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.BatchDetectKeyPhrasesRequest,
      BatchDetectKeyPhrasesResponse
    ]("batchDetectKeyPhrases", api.batchDetectKeyPhrases)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.wrap)
      .provideEnvironment(r)
    def deleteEndpoint(
        request: DeleteEndpointRequest
    ): IO[AwsError, zio.aws.comprehend.model.DeleteEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.DeleteEndpointRequest,
        DeleteEndpointResponse
      ]("deleteEndpoint", api.deleteEndpoint)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.DeleteEndpointResponse.wrap)
        .provideEnvironment(r)
    def detectDominantLanguage(request: DetectDominantLanguageRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DetectDominantLanguageRequest,
      DetectDominantLanguageResponse
    ]("detectDominantLanguage", api.detectDominantLanguage)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DetectDominantLanguageResponse.wrap)
      .provideEnvironment(r)
    def describeKeyPhrasesDetectionJob(
        request: DescribeKeyPhrasesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeKeyPhrasesDetectionJobRequest,
      DescribeKeyPhrasesDetectionJobResponse
    ]("describeKeyPhrasesDetectionJob", api.describeKeyPhrasesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def batchDetectSentiment(request: BatchDetectSentimentRequest): IO[
      AwsError,
      zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.BatchDetectSentimentRequest,
      BatchDetectSentimentResponse
    ]("batchDetectSentiment", api.batchDetectSentiment)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.BatchDetectSentimentResponse.wrap)
      .provideEnvironment(r)
    def startTopicsDetectionJob(request: StartTopicsDetectionJobRequest): IO[
      AwsError,
      zio.aws.comprehend.model.StartTopicsDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartTopicsDetectionJobRequest,
      StartTopicsDetectionJobResponse
    ]("startTopicsDetectionJob", api.startTopicsDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartTopicsDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def batchDetectDominantLanguage(
        request: BatchDetectDominantLanguageRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.BatchDetectDominantLanguageRequest,
      BatchDetectDominantLanguageResponse
    ]("batchDetectDominantLanguage", api.batchDetectDominantLanguage)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.wrap)
      .provideEnvironment(r)
    def startKeyPhrasesDetectionJob(
        request: StartKeyPhrasesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartKeyPhrasesDetectionJobRequest,
      StartKeyPhrasesDetectionJobResponse
    ]("startKeyPhrasesDetectionJob", api.startKeyPhrasesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def deleteDocumentClassifier(request: DeleteDocumentClassifierRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DeleteDocumentClassifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DeleteDocumentClassifierRequest,
      DeleteDocumentClassifierResponse
    ]("deleteDocumentClassifier", api.deleteDocumentClassifier)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DeleteDocumentClassifierResponse.wrap)
      .provideEnvironment(r)
    def startPiiEntitiesDetectionJob(
        request: StartPiiEntitiesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartPiiEntitiesDetectionJobRequest,
      StartPiiEntitiesDetectionJobResponse
    ]("startPiiEntitiesDetectionJob", api.startPiiEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def startDocumentClassificationJob(
        request: StartDocumentClassificationJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartDocumentClassificationJobRequest,
      StartDocumentClassificationJobResponse
    ]("startDocumentClassificationJob", api.startDocumentClassificationJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartDocumentClassificationJobResponse.wrap)
      .provideEnvironment(r)
    def classifyDocument(request: ClassifyDocumentRequest): IO[
      AwsError,
      zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ClassifyDocumentRequest,
      ClassifyDocumentResponse
    ]("classifyDocument", api.classifyDocument)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.ClassifyDocumentResponse.wrap)
      .provideEnvironment(r)
    def describeDocumentClassifier(
        request: DescribeDocumentClassifierRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassifierRequest,
      DescribeDocumentClassifierResponse
    ]("describeDocumentClassifier", api.describeDocumentClassifier)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeDocumentClassifierResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.comprehend.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeEndpoint(request: DescribeEndpointRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeEndpointRequest,
      DescribeEndpointResponse
    ]("describeEndpoint", api.describeEndpoint)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.DescribeEndpointResponse.wrap)
      .provideEnvironment(r)
    def listDocumentClassifierSummaries(
        request: ListDocumentClassifierSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest,
      ListDocumentClassifierSummariesResponse,
      DocumentClassifierSummary
    ](
      "listDocumentClassifierSummaries",
      api.listDocumentClassifierSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.documentClassifierSummariesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.DocumentClassifierSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDocumentClassifierSummariesPaginated(
        request: ListDocumentClassifierSummariesRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesRequest,
      ListDocumentClassifierSummariesResponse
    ]("listDocumentClassifierSummaries", api.listDocumentClassifierSummaries)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.wrap)
      .provideEnvironment(r)
    def listKeyPhrasesDetectionJobs(
        request: ListKeyPhrasesDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest,
      ListKeyPhrasesDetectionJobsResponse,
      KeyPhrasesDetectionJobProperties
    ](
      "listKeyPhrasesDetectionJobs",
      api.listKeyPhrasesDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.keyPhrasesDetectionJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listKeyPhrasesDetectionJobsPaginated(
        request: ListKeyPhrasesDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListKeyPhrasesDetectionJobsRequest,
      ListKeyPhrasesDetectionJobsResponse
    ]("listKeyPhrasesDetectionJobs", api.listKeyPhrasesDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def stopEntitiesDetectionJob(request: StopEntitiesDetectionJobRequest): IO[
      AwsError,
      zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopEntitiesDetectionJobRequest,
      StopEntitiesDetectionJobResponse
    ]("stopEntitiesDetectionJob", api.stopEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def listSentimentDetectionJobs(
        request: ListSentimentDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest,
      ListSentimentDetectionJobsResponse,
      SentimentDetectionJobProperties
    ](
      "listSentimentDetectionJobs",
      api.listSentimentDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.sentimentDetectionJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.SentimentDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listSentimentDetectionJobsPaginated(
        request: ListSentimentDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListSentimentDetectionJobsRequest,
      ListSentimentDetectionJobsResponse
    ]("listSentimentDetectionJobs", api.listSentimentDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def stopTargetedSentimentDetectionJob(
        request: StopTargetedSentimentDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopTargetedSentimentDetectionJobRequest,
      StopTargetedSentimentDetectionJobResponse
    ](
      "stopTargetedSentimentDetectionJob",
      api.stopTargetedSentimentDetectionJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.wrap
      )
      .provideEnvironment(r)
    def listDocumentClassificationJobs(
        request: ListDocumentClassificationJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest,
      ListDocumentClassificationJobsResponse,
      DocumentClassificationJobProperties
    ](
      "listDocumentClassificationJobs",
      api.listDocumentClassificationJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.documentClassificationJobPropertiesList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.DocumentClassificationJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listDocumentClassificationJobsPaginated(
        request: ListDocumentClassificationJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassificationJobsRequest,
      ListDocumentClassificationJobsResponse
    ]("listDocumentClassificationJobs", api.listDocumentClassificationJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.wrap)
      .provideEnvironment(r)
    def deleteResourcePolicy(request: DeleteResourcePolicyRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DeleteResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DeleteResourcePolicyRequest,
      DeleteResourcePolicyResponse
    ]("deleteResourcePolicy", api.deleteResourcePolicy)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.DeleteResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def stopTrainingEntityRecognizer(
        request: StopTrainingEntityRecognizerRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopTrainingEntityRecognizerRequest,
      StopTrainingEntityRecognizerResponse
    ]("stopTrainingEntityRecognizer", api.stopTrainingEntityRecognizer)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.comprehend.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createEndpoint(
        request: CreateEndpointRequest
    ): IO[AwsError, zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.CreateEndpointRequest,
        CreateEndpointResponse
      ]("createEndpoint", api.createEndpoint)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.CreateEndpointResponse.wrap)
        .provideEnvironment(r)
    def stopKeyPhrasesDetectionJob(
        request: StopKeyPhrasesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopKeyPhrasesDetectionJobRequest,
      StopKeyPhrasesDetectionJobResponse
    ]("stopKeyPhrasesDetectionJob", api.stopKeyPhrasesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def detectSentiment(
        request: DetectSentimentRequest
    ): IO[AwsError, zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.DetectSentimentRequest,
        DetectSentimentResponse
      ]("detectSentiment", api.detectSentiment)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.DetectSentimentResponse.wrap)
        .provideEnvironment(r)
    def updateEndpoint(
        request: UpdateEndpointRequest
    ): IO[AwsError, zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.UpdateEndpointRequest,
        UpdateEndpointResponse
      ]("updateEndpoint", api.updateEndpoint)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.UpdateEndpointResponse.wrap)
        .provideEnvironment(r)
    def listEndpoints(request: ListEndpointsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.EndpointProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest,
      ListEndpointsResponse,
      EndpointProperties
    ](
      "listEndpoints",
      api.listEndpoints,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.endpointPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.comprehend.model.EndpointProperties.wrap(item))
      .provideEnvironment(r)
    def listEndpointsPaginated(
        request: ListEndpointsRequest
    ): IO[AwsError, zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.ListEndpointsRequest,
        ListEndpointsResponse
      ]("listEndpoints", api.listEndpoints)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.ListEndpointsResponse.wrap)
        .provideEnvironment(r)
    def importModel(
        request: ImportModelRequest
    ): IO[AwsError, zio.aws.comprehend.model.ImportModelResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.ImportModelRequest,
        ImportModelResponse
      ]("importModel", api.importModel)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.ImportModelResponse.wrap)
        .provideEnvironment(r)
    def startEntitiesDetectionJob(
        request: StartEntitiesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartEntitiesDetectionJobRequest,
      StartEntitiesDetectionJobResponse
    ]("startEntitiesDetectionJob", api.startEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def createEntityRecognizer(request: CreateEntityRecognizerRequest): IO[
      AwsError,
      zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.CreateEntityRecognizerRequest,
      CreateEntityRecognizerResponse
    ]("createEntityRecognizer", api.createEntityRecognizer)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.CreateEntityRecognizerResponse.wrap)
      .provideEnvironment(r)
    def describeResourcePolicy(request: DescribeResourcePolicyRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest,
      DescribeResourcePolicyResponse
    ]("describeResourcePolicy", api.describeResourcePolicy)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribeResourcePolicyResponse.wrap)
      .provideEnvironment(r)
    def listEventsDetectionJobs(
        request: ListEventsDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest,
      ListEventsDetectionJobsResponse,
      EventsDetectionJobProperties
    ](
      "listEventsDetectionJobs",
      api.listEventsDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventsDetectionJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.EventsDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listEventsDetectionJobsPaginated(
        request: ListEventsDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListEventsDetectionJobsRequest,
      ListEventsDetectionJobsResponse
    ]("listEventsDetectionJobs", api.listEventsDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListEventsDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def listDocumentClassifiers(
        request: ListDocumentClassifiersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest,
      ListDocumentClassifiersResponse,
      DocumentClassifierProperties
    ](
      "listDocumentClassifiers",
      api.listDocumentClassifiers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.documentClassifierPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.DocumentClassifierProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listDocumentClassifiersPaginated(
        request: ListDocumentClassifiersRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListDocumentClassifiersRequest,
      ListDocumentClassifiersResponse
    ]("listDocumentClassifiers", api.listDocumentClassifiers)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListDocumentClassifiersResponse.wrap)
      .provideEnvironment(r)
    def startDominantLanguageDetectionJob(
        request: StartDominantLanguageDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StartDominantLanguageDetectionJobRequest,
      StartDominantLanguageDetectionJobResponse
    ](
      "startDominantLanguageDetectionJob",
      api.startDominantLanguageDetectionJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.wrap
      )
      .provideEnvironment(r)
    def listEntitiesDetectionJobs(
        request: ListEntitiesDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest,
      ListEntitiesDetectionJobsResponse,
      EntitiesDetectionJobProperties
    ](
      "listEntitiesDetectionJobs",
      api.listEntitiesDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.entitiesDetectionJobPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.EntitiesDetectionJobProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listEntitiesDetectionJobsPaginated(
        request: ListEntitiesDetectionJobsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListEntitiesDetectionJobsRequest,
      ListEntitiesDetectionJobsResponse
    ]("listEntitiesDetectionJobs", api.listEntitiesDetectionJobs)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListEntitiesDetectionJobsResponse.wrap)
      .provideEnvironment(r)
    def listDominantLanguageDetectionJobs(
        request: ListDominantLanguageDetectionJobsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest,
      ListDominantLanguageDetectionJobsResponse,
      DominantLanguageDetectionJobProperties
    ](
      "listDominantLanguageDetectionJobs",
      api.listDominantLanguageDetectionJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.dominantLanguageDetectionJobPropertiesList().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.DominantLanguageDetectionJobProperties
          .wrap(item)
      )
      .provideEnvironment(r)
    def listDominantLanguageDetectionJobsPaginated(
        request: ListDominantLanguageDetectionJobsRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListDominantLanguageDetectionJobsRequest,
      ListDominantLanguageDetectionJobsResponse
    ](
      "listDominantLanguageDetectionJobs",
      api.listDominantLanguageDetectionJobs
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.wrap
      )
      .provideEnvironment(r)
    def detectPiiEntities(request: DetectPiiEntitiesRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DetectPiiEntitiesRequest,
      DetectPiiEntitiesResponse
    ]("detectPiiEntities", api.detectPiiEntities)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.DetectPiiEntitiesResponse.wrap)
      .provideEnvironment(r)
    def deleteEntityRecognizer(request: DeleteEntityRecognizerRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DeleteEntityRecognizerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DeleteEntityRecognizerRequest,
      DeleteEntityRecognizerResponse
    ]("deleteEntityRecognizer", api.deleteEntityRecognizer)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DeleteEntityRecognizerResponse.wrap)
      .provideEnvironment(r)
    def describePiiEntitiesDetectionJob(
        request: DescribePiiEntitiesDetectionJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribePiiEntitiesDetectionJobRequest,
      DescribePiiEntitiesDetectionJobResponse
    ]("describePiiEntitiesDetectionJob", api.describePiiEntitiesDetectionJob)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.wrap)
      .provideEnvironment(r)
    def detectSyntax(
        request: DetectSyntaxRequest
    ): IO[AwsError, zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.comprehend.model.DetectSyntaxRequest,
        DetectSyntaxResponse
      ]("detectSyntax", api.detectSyntax)(request.buildAwsValue())
        .map(zio.aws.comprehend.model.DetectSyntaxResponse.wrap)
        .provideEnvironment(r)
    def listEntityRecognizers(request: ListEntityRecognizersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest,
      ListEntityRecognizersResponse,
      EntityRecognizerProperties
    ](
      "listEntityRecognizers",
      api.listEntityRecognizers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entityRecognizerPropertiesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.comprehend.model.EntityRecognizerProperties.wrap(item)
      )
      .provideEnvironment(r)
    def listEntityRecognizersPaginated(
        request: ListEntityRecognizersRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListEntityRecognizersRequest,
      ListEntityRecognizersResponse
    ]("listEntityRecognizers", api.listEntityRecognizers)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListEntityRecognizersResponse.wrap)
      .provideEnvironment(r)
    def batchDetectSyntax(request: BatchDetectSyntaxRequest): IO[
      AwsError,
      zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.BatchDetectSyntaxRequest,
      BatchDetectSyntaxResponse
    ]("batchDetectSyntax", api.batchDetectSyntax)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.BatchDetectSyntaxResponse.wrap)
      .provideEnvironment(r)
    def stopTrainingDocumentClassifier(
        request: StopTrainingDocumentClassifierRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.StopTrainingDocumentClassifierRequest,
      StopTrainingDocumentClassifierResponse
    ]("stopTrainingDocumentClassifier", api.stopTrainingDocumentClassifier)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.wrap)
      .provideEnvironment(r)
    def describeDocumentClassificationJob(
        request: DescribeDocumentClassificationJobRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DescribeDocumentClassificationJobRequest,
      DescribeDocumentClassificationJobResponse
    ](
      "describeDocumentClassificationJob",
      api.describeDocumentClassificationJob
    )(request.buildAwsValue())
      .map(
        zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.wrap
      )
      .provideEnvironment(r)
    def listEntityRecognizerSummaries(
        request: ListEntityRecognizerSummariesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest,
      ListEntityRecognizerSummariesResponse,
      EntityRecognizerSummary
    ](
      "listEntityRecognizerSummaries",
      api.listEntityRecognizerSummaries,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.entityRecognizerSummariesList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.comprehend.model.EntityRecognizerSummary.wrap(item))
      .provideEnvironment(r)
    def listEntityRecognizerSummariesPaginated(
        request: ListEntityRecognizerSummariesRequest
    ): IO[
      AwsError,
      zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.ListEntityRecognizerSummariesRequest,
      ListEntityRecognizerSummariesResponse
    ]("listEntityRecognizerSummaries", api.listEntityRecognizerSummaries)(
      request.buildAwsValue()
    ).map(zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.wrap)
      .provideEnvironment(r)
    def detectKeyPhrases(request: DetectKeyPhrasesRequest): IO[
      AwsError,
      zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.comprehend.model.DetectKeyPhrasesRequest,
      DetectKeyPhrasesResponse
    ]("detectKeyPhrases", api.detectKeyPhrases)(request.buildAwsValue())
      .map(zio.aws.comprehend.model.DetectKeyPhrasesResponse.wrap)
      .provideEnvironment(r)
  }
  def listTargetedSentimentDetectionJobs(
      request: ListTargetedSentimentDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.TargetedSentimentDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listTargetedSentimentDetectionJobs(request))
  def listTargetedSentimentDetectionJobsPaginated(
      request: ListTargetedSentimentDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListTargetedSentimentDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTargetedSentimentDetectionJobsPaginated(request))
  def describeEntitiesDetectionJob(
      request: DescribeEntitiesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEntitiesDetectionJob(request))
  def startSentimentDetectionJob(
      request: StartSentimentDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startSentimentDetectionJob(request))
  def listTopicsDetectionJobs(request: ListTopicsDetectionJobsRequest): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.TopicsDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listTopicsDetectionJobs(request))
  def listTopicsDetectionJobsPaginated(
      request: ListTopicsDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListTopicsDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTopicsDetectionJobsPaginated(request))
  def createDocumentClassifier(request: CreateDocumentClassifierRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.CreateDocumentClassifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDocumentClassifier(request))
  def describeDominantLanguageDetectionJob(
      request: DescribeDominantLanguageDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeDominantLanguageDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDominantLanguageDetectionJob(request))
  def describeEventsDetectionJob(
      request: DescribeEventsDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeEventsDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsDetectionJob(request))
  def stopPiiEntitiesDetectionJob(
      request: StopPiiEntitiesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopPiiEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopPiiEntitiesDetectionJob(request))
  def listPiiEntitiesDetectionJobs(
      request: ListPiiEntitiesDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.PiiEntitiesDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listPiiEntitiesDetectionJobs(request))
  def listPiiEntitiesDetectionJobsPaginated(
      request: ListPiiEntitiesDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListPiiEntitiesDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPiiEntitiesDetectionJobsPaginated(request))
  def describeTargetedSentimentDetectionJob(
      request: DescribeTargetedSentimentDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeTargetedSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTargetedSentimentDetectionJob(request))
  def stopEventsDetectionJob(request: StopEventsDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopEventsDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopEventsDetectionJob(request))
  def containsPiiEntities(request: ContainsPiiEntitiesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ContainsPiiEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.containsPiiEntities(request))
  def describeSentimentDetectionJob(
      request: DescribeSentimentDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSentimentDetectionJob(request))
  def describeEntityRecognizer(request: DescribeEntityRecognizerRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeEntityRecognizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEntityRecognizer(request))
  def stopSentimentDetectionJob(request: StopSentimentDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopSentimentDetectionJob(request))
  def detectEntities(request: DetectEntitiesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectEntities(request))
  def putResourcePolicy(request: PutResourcePolicyRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.PutResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourcePolicy(request))
  def describeTopicsDetectionJob(
      request: DescribeTopicsDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeTopicsDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTopicsDetectionJob(request))
  def stopDominantLanguageDetectionJob(
      request: StopDominantLanguageDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopDominantLanguageDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDominantLanguageDetectionJob(request))
  def startEventsDetectionJob(request: StartEventsDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartEventsDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startEventsDetectionJob(request))
  def batchDetectEntities(request: BatchDetectEntitiesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.BatchDetectEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDetectEntities(request))
  def startTargetedSentimentDetectionJob(
      request: StartTargetedSentimentDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartTargetedSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTargetedSentimentDetectionJob(request))
  def batchDetectKeyPhrases(request: BatchDetectKeyPhrasesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.BatchDetectKeyPhrasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDetectKeyPhrases(request))
  def deleteEndpoint(request: DeleteEndpointRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DeleteEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEndpoint(request))
  def detectDominantLanguage(request: DetectDominantLanguageRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectDominantLanguageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectDominantLanguage(request))
  def describeKeyPhrasesDetectionJob(
      request: DescribeKeyPhrasesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeKeyPhrasesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKeyPhrasesDetectionJob(request))
  def batchDetectSentiment(request: BatchDetectSentimentRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.BatchDetectSentimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDetectSentiment(request))
  def startTopicsDetectionJob(request: StartTopicsDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartTopicsDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTopicsDetectionJob(request))
  def batchDetectDominantLanguage(
      request: BatchDetectDominantLanguageRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.BatchDetectDominantLanguageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDetectDominantLanguage(request))
  def startKeyPhrasesDetectionJob(
      request: StartKeyPhrasesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartKeyPhrasesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startKeyPhrasesDetectionJob(request))
  def deleteDocumentClassifier(request: DeleteDocumentClassifierRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DeleteDocumentClassifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDocumentClassifier(request))
  def startPiiEntitiesDetectionJob(
      request: StartPiiEntitiesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartPiiEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startPiiEntitiesDetectionJob(request))
  def startDocumentClassificationJob(
      request: StartDocumentClassificationJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartDocumentClassificationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDocumentClassificationJob(request))
  def classifyDocument(request: ClassifyDocumentRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ClassifyDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.classifyDocument(request))
  def describeDocumentClassifier(
      request: DescribeDocumentClassifierRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeDocumentClassifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDocumentClassifier(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeEndpoint(request: DescribeEndpointRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEndpoint(request))
  def listDocumentClassifierSummaries(
      request: ListDocumentClassifierSummariesRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDocumentClassifierSummaries(request))
  def listDocumentClassifierSummariesPaginated(
      request: ListDocumentClassifierSummariesRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentClassifierSummariesPaginated(request))
  def listKeyPhrasesDetectionJobs(
      request: ListKeyPhrasesDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.KeyPhrasesDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listKeyPhrasesDetectionJobs(request))
  def listKeyPhrasesDetectionJobsPaginated(
      request: ListKeyPhrasesDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListKeyPhrasesDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeyPhrasesDetectionJobsPaginated(request))
  def stopEntitiesDetectionJob(request: StopEntitiesDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopEntitiesDetectionJob(request))
  def listSentimentDetectionJobs(
      request: ListSentimentDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.SentimentDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listSentimentDetectionJobs(request))
  def listSentimentDetectionJobsPaginated(
      request: ListSentimentDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListSentimentDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSentimentDetectionJobsPaginated(request))
  def stopTargetedSentimentDetectionJob(
      request: StopTargetedSentimentDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopTargetedSentimentDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopTargetedSentimentDetectionJob(request))
  def listDocumentClassificationJobs(
      request: ListDocumentClassificationJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listDocumentClassificationJobs(request))
  def listDocumentClassificationJobsPaginated(
      request: ListDocumentClassificationJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassificationJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentClassificationJobsPaginated(request))
  def deleteResourcePolicy(request: DeleteResourcePolicyRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DeleteResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteResourcePolicy(request))
  def stopTrainingEntityRecognizer(
      request: StopTrainingEntityRecognizerRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopTrainingEntityRecognizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopTrainingEntityRecognizer(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createEndpoint(request: CreateEndpointRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.CreateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEndpoint(request))
  def stopKeyPhrasesDetectionJob(
      request: StopKeyPhrasesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopKeyPhrasesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopKeyPhrasesDetectionJob(request))
  def detectSentiment(request: DetectSentimentRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectSentimentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectSentiment(request))
  def updateEndpoint(request: UpdateEndpointRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.UpdateEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEndpoint(request))
  def listEndpoints(request: ListEndpointsRequest): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.EndpointProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listEndpoints(request))
  def listEndpointsPaginated(request: ListEndpointsRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEndpointsPaginated(request))
  def importModel(request: ImportModelRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ImportModelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importModel(request))
  def startEntitiesDetectionJob(request: StartEntitiesDetectionJobRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startEntitiesDetectionJob(request))
  def createEntityRecognizer(request: CreateEntityRecognizerRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.CreateEntityRecognizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEntityRecognizer(request))
  def describeResourcePolicy(request: DescribeResourcePolicyRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeResourcePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeResourcePolicy(request))
  def listEventsDetectionJobs(request: ListEventsDetectionJobsRequest): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.EventsDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventsDetectionJobs(request))
  def listEventsDetectionJobsPaginated(
      request: ListEventsDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListEventsDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventsDetectionJobsPaginated(request))
  def listDocumentClassifiers(request: ListDocumentClassifiersRequest): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DocumentClassifierProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listDocumentClassifiers(request))
  def listDocumentClassifiersPaginated(
      request: ListDocumentClassifiersRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListDocumentClassifiersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDocumentClassifiersPaginated(request))
  def startDominantLanguageDetectionJob(
      request: StartDominantLanguageDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StartDominantLanguageDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDominantLanguageDetectionJob(request))
  def listEntitiesDetectionJobs(
      request: ListEntitiesDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.EntitiesDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listEntitiesDetectionJobs(request))
  def listEntitiesDetectionJobsPaginated(
      request: ListEntitiesDetectionJobsRequest
  ): ZIO[zio.aws.comprehend.Comprehend, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listEntitiesDetectionJobsPaginated(request))
  def listDominantLanguageDetectionJobs(
      request: ListDominantLanguageDetectionJobsRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DominantLanguageDetectionJobProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listDominantLanguageDetectionJobs(request))
  def listDominantLanguageDetectionJobsPaginated(
      request: ListDominantLanguageDetectionJobsRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListDominantLanguageDetectionJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDominantLanguageDetectionJobsPaginated(request))
  def detectPiiEntities(request: DetectPiiEntitiesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectPiiEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectPiiEntities(request))
  def deleteEntityRecognizer(request: DeleteEntityRecognizerRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DeleteEntityRecognizerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEntityRecognizer(request))
  def describePiiEntitiesDetectionJob(
      request: DescribePiiEntitiesDetectionJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribePiiEntitiesDetectionJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePiiEntitiesDetectionJob(request))
  def detectSyntax(request: DetectSyntaxRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectSyntaxResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectSyntax(request))
  def listEntityRecognizers(request: ListEntityRecognizersRequest): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.EntityRecognizerProperties.ReadOnly
  ] = ZStream.serviceWithStream(_.listEntityRecognizers(request))
  def listEntityRecognizersPaginated(
      request: ListEntityRecognizersRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListEntityRecognizersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntityRecognizersPaginated(request))
  def batchDetectSyntax(request: BatchDetectSyntaxRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.BatchDetectSyntaxResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDetectSyntax(request))
  def stopTrainingDocumentClassifier(
      request: StopTrainingDocumentClassifierRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.StopTrainingDocumentClassifierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopTrainingDocumentClassifier(request))
  def describeDocumentClassificationJob(
      request: DescribeDocumentClassificationJobRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DescribeDocumentClassificationJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDocumentClassificationJob(request))
  def listEntityRecognizerSummaries(
      request: ListEntityRecognizerSummariesRequest
  ): ZStream[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.EntityRecognizerSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listEntityRecognizerSummaries(request))
  def listEntityRecognizerSummariesPaginated(
      request: ListEntityRecognizerSummariesRequest
  ): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.ListEntityRecognizerSummariesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEntityRecognizerSummariesPaginated(request))
  def detectKeyPhrases(request: DetectKeyPhrasesRequest): ZIO[
    zio.aws.comprehend.Comprehend,
    AwsError,
    zio.aws.comprehend.model.DetectKeyPhrasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detectKeyPhrases(request))
}
