package zio.aws.comprehend.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDocumentClassifierSummariesResponse(
    documentClassifierSummariesList: Option[
      Iterable[zio.aws.comprehend.model.DocumentClassifierSummary]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse = {
    import ListDocumentClassifierSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse
      .builder()
      .optionallyWith(
        documentClassifierSummariesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentClassifierSummariesList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly =
    zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse
      .wrap(buildAwsValue())
}
object ListDocumentClassifierSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse =
      zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse(
        documentClassifierSummariesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def documentClassifierSummariesList: Option[
      List[zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly]
    ]
    def nextToken: Option[String]
    def getDocumentClassifierSummariesList: ZIO[Any, AwsError, List[
      zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentClassifierSummariesList",
      documentClassifierSummariesList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse
  ) extends zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly {
    override val documentClassifierSummariesList: Option[
      List[zio.aws.comprehend.model.DocumentClassifierSummary.ReadOnly]
    ] = scala
      .Option(impl.documentClassifierSummariesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.comprehend.model.DocumentClassifierSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.ListDocumentClassifierSummariesResponse
  ): zio.aws.comprehend.model.ListDocumentClassifierSummariesResponse.ReadOnly =
    new Wrapper(impl)
}
