package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.ComprehendModelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeResourcePolicyRequest(
    resourceArn: ComprehendModelArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest = {
    import DescribeResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest
      .builder()
      .resourceArn(ComprehendModelArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DescribeResourcePolicyRequest.ReadOnly =
    zio.aws.comprehend.model.DescribeResourcePolicyRequest.wrap(buildAwsValue())
}
object DescribeResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.comprehend.model.DescribeResourcePolicyRequest =
      zio.aws.comprehend.model.DescribeResourcePolicyRequest(resourceArn)
    def resourceArn: ComprehendModelArn
    def getResourceArn: ZIO[Any, Nothing, ComprehendModelArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest
  ) extends zio.aws.comprehend.model.DescribeResourcePolicyRequest.ReadOnly {
    override val resourceArn: ComprehendModelArn =
      zio.aws.comprehend.model.primitives.ComprehendModelArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DescribeResourcePolicyRequest
  ): zio.aws.comprehend.model.DescribeResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
