package zio.aws.comprehend.model
import zio.aws.comprehend.model.primitives.{
  DocumentClassifierArn,
  IamRoleArn,
  AnyLengthString,
  Timestamp,
  JobName,
  KmsKeyId,
  JobId,
  ComprehendArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DocumentClassificationJobProperties(
    jobId: Option[JobId] = None,
    jobArn: Option[ComprehendArn] = None,
    jobName: Option[JobName] = None,
    jobStatus: Option[zio.aws.comprehend.model.JobStatus] = None,
    message: Option[AnyLengthString] = None,
    submitTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    documentClassifierArn: Option[DocumentClassifierArn] = None,
    inputDataConfig: Option[zio.aws.comprehend.model.InputDataConfig] = None,
    outputDataConfig: Option[zio.aws.comprehend.model.OutputDataConfig] = None,
    dataAccessRoleArn: Option[IamRoleArn] = None,
    volumeKmsKeyId: Option[KmsKeyId] = None,
    vpcConfig: Option[zio.aws.comprehend.model.VpcConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties = {
    import DocumentClassificationJobProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(
        jobArn.map(value => ComprehendArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        message.map(value => AnyLengthString.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        submitTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.submitTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        documentClassifierArn.map(value =>
          DocumentClassifierArn.unwrap(value): java.lang.String
        )
      )(_.documentClassifierArn)
      .optionallyWith(inputDataConfig.map(value => value.buildAwsValue()))(
        _.inputDataConfig
      )
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .optionallyWith(
        dataAccessRoleArn.map(value =>
          IamRoleArn.unwrap(value): java.lang.String
        )
      )(_.dataAccessRoleArn)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly =
    zio.aws.comprehend.model.DocumentClassificationJobProperties
      .wrap(buildAwsValue())
}
object DocumentClassificationJobProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.comprehend.model.DocumentClassificationJobProperties =
      zio.aws.comprehend.model.DocumentClassificationJobProperties(
        jobId.map(value => value),
        jobArn.map(value => value),
        jobName.map(value => value),
        jobStatus.map(value => value),
        message.map(value => value),
        submitTime.map(value => value),
        endTime.map(value => value),
        documentClassifierArn.map(value => value),
        inputDataConfig.map(value => value.asEditable),
        outputDataConfig.map(value => value.asEditable),
        dataAccessRoleArn.map(value => value),
        volumeKmsKeyId.map(value => value),
        vpcConfig.map(value => value.asEditable)
      )
    def jobId: Option[JobId]
    def jobArn: Option[ComprehendArn]
    def jobName: Option[JobName]
    def jobStatus: Option[zio.aws.comprehend.model.JobStatus]
    def message: Option[AnyLengthString]
    def submitTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def documentClassifierArn: Option[DocumentClassifierArn]
    def inputDataConfig
        : Option[zio.aws.comprehend.model.InputDataConfig.ReadOnly]
    def outputDataConfig
        : Option[zio.aws.comprehend.model.OutputDataConfig.ReadOnly]
    def dataAccessRoleArn: Option[IamRoleArn]
    def volumeKmsKeyId: Option[KmsKeyId]
    def vpcConfig: Option[zio.aws.comprehend.model.VpcConfig.ReadOnly]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobArn: ZIO[Any, AwsError, ComprehendArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.comprehend.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getMessage: ZIO[Any, AwsError, AnyLengthString] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("submitTime", submitTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getDocumentClassifierArn: ZIO[Any, AwsError, DocumentClassifierArn] =
      AwsError.unwrapOptionField("documentClassifierArn", documentClassifierArn)
    def getInputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.InputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.comprehend.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getDataAccessRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("dataAccessRoleArn", dataAccessRoleArn)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.comprehend.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties
  ) extends zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.comprehend.model.primitives.JobId(value))
    override val jobArn: Option[ComprehendArn] = scala
      .Option(impl.jobArn())
      .map(value => zio.aws.comprehend.model.primitives.ComprehendArn(value))
    override val jobName: Option[JobName] = scala
      .Option(impl.jobName())
      .map(value => zio.aws.comprehend.model.primitives.JobName(value))
    override val jobStatus: Option[zio.aws.comprehend.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.comprehend.model.JobStatus.wrap(value))
    override val message: Option[AnyLengthString] = scala
      .Option(impl.message())
      .map(value => zio.aws.comprehend.model.primitives.AnyLengthString(value))
    override val submitTime: Option[Timestamp] = scala
      .Option(impl.submitTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.comprehend.model.primitives.Timestamp(value))
    override val documentClassifierArn: Option[DocumentClassifierArn] = scala
      .Option(impl.documentClassifierArn())
      .map(value =>
        zio.aws.comprehend.model.primitives.DocumentClassifierArn(value)
      )
    override val inputDataConfig
        : Option[zio.aws.comprehend.model.InputDataConfig.ReadOnly] = scala
      .Option(impl.inputDataConfig())
      .map(value => zio.aws.comprehend.model.InputDataConfig.wrap(value))
    override val outputDataConfig
        : Option[zio.aws.comprehend.model.OutputDataConfig.ReadOnly] = scala
      .Option(impl.outputDataConfig())
      .map(value => zio.aws.comprehend.model.OutputDataConfig.wrap(value))
    override val dataAccessRoleArn: Option[IamRoleArn] = scala
      .Option(impl.dataAccessRoleArn())
      .map(value => zio.aws.comprehend.model.primitives.IamRoleArn(value))
    override val volumeKmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.volumeKmsKeyId())
      .map(value => zio.aws.comprehend.model.primitives.KmsKeyId(value))
    override val vpcConfig
        : Option[zio.aws.comprehend.model.VpcConfig.ReadOnly] = scala
      .Option(impl.vpcConfig())
      .map(value => zio.aws.comprehend.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.comprehend.model.DocumentClassificationJobProperties
  ): zio.aws.comprehend.model.DocumentClassificationJobProperties.ReadOnly =
    new Wrapper(impl)
}
